/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.List;
import org.testng.CommandLineArgs;
import org.testng.IInvokedMethodListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestRunnerFactory;
import org.testng.TestNG;
import org.testng.TestRunner;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.RemoteMessageSenderTestListener;
import org.testng.remote.strprotocol.StringMessageSenderHelper;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class RemoteTestNG
extends TestNG {
    private static final String LOCALHOST = "127.0.0.1";
    private ITestRunnerFactory m_customTestRunnerFactory;
    protected String m_host;
    protected int m_port;

    public void setConnectionParameters(String host, int port) {
        this.m_host = null == host || "".equals(host) ? LOCALHOST : host;
        this.m_port = port;
    }

    public void configure(CommandLineArgs args) {
        super.configure(args);
        this.setConnectionParameters(args.host, args.port);
        System.out.println("Setting connection parameters:" + this.m_host + ":" + this.m_port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        StringMessageSenderHelper msh = new StringMessageSenderHelper(this.m_host, this.m_port);
        try {
            try {
                if (msh.connect()) {
                    if (this.m_suites.size() > 0) {
                        int testCount = 0;
                        for (int i = 0; i < this.m_suites.size(); testCount += ((XmlSuite)this.m_suites.get(i)).getTests().size(), ++i) {
                        }
                        GenericMessage gm = new GenericMessage(1);
                        gm.addProperty("suiteCount", this.m_suites.size()).addProperty("testCount", testCount);
                        msh.sendMessage(gm);
                        this.addListener(new RemoteSuiteListener(msh));
                        this.setTestRunnerFactory(new DelegatingTestRunnerFactory(this.buildTestRunnerFactory(), msh));
                        super.run();
                    }
                    System.err.println("No test suite found.  Nothing to run");
                }
                System.err.println("Cannot connect to " + this.m_host + " on " + this.m_port);
            }
            catch (Throwable cause) {
                cause.printStackTrace(System.err);
                Object var5_7 = null;
                msh.shutDown();
                System.exit(0);
                return;
            }
            Object var5_6 = null;
            msh.shutDown();
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            msh.shutDown();
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    protected ITestRunnerFactory buildTestRunnerFactory() {
        if (null == this.m_customTestRunnerFactory) {
            this.m_customTestRunnerFactory = new ITestRunnerFactory(){

                @Override
                public TestRunner newTestRunner(ISuite suite, XmlTest xmlTest, List<IInvokedMethodListener> listeners) {
                    TestRunner runner = new TestRunner(suite, xmlTest, false, listeners);
                    if (RemoteTestNG.this.m_useDefaultListeners) {
                        runner.addListener(new TestHTMLReporter());
                        runner.addListener(new JUnitXMLReporter());
                    }
                    return runner;
                }
            };
        }
        return this.m_customTestRunnerFactory;
    }

    public static void main(String[] args) throws ParameterException {
        CommandLineArgs cla = new CommandLineArgs();
        new JCommander((Object)cla, args);
        RemoteTestNG.validateCommandLineParameters(cla);
        RemoteTestNG testNG = new RemoteTestNG();
        testNG.configure(cla);
        testNG.initializeSuitesAndJarFile();
        testNG.run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingTestRunnerFactory
    implements ITestRunnerFactory {
        private final ITestRunnerFactory m_delegateFactory;
        private final StringMessageSenderHelper m_messageSender;

        DelegatingTestRunnerFactory(ITestRunnerFactory trf, StringMessageSenderHelper smsh) {
            this.m_delegateFactory = trf;
            this.m_messageSender = smsh;
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, List<IInvokedMethodListener> listeners) {
            TestRunner tr = this.m_delegateFactory.newTestRunner(suite, test, listeners);
            tr.addListener(new RemoteMessageSenderTestListener(suite, test, this.m_messageSender));
            return tr;
        }
    }

    private static class RemoteSuiteListener
    implements ISuiteListener {
        private final StringMessageSenderHelper m_messageSender;

        RemoteSuiteListener(StringMessageSenderHelper smsh) {
            this.m_messageSender = smsh;
        }

        public void onFinish(ISuite suite) {
            this.m_messageSender.sendMessage(new SuiteMessage(suite, false));
        }

        public void onStart(ISuite suite) {
            this.m_messageSender.sendMessage(new SuiteMessage(suite, true));
        }
    }
}

