/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicButtonUI;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.BGPanel;
import replicatorg.app.ui.MainWindow;
import replicatorg.model.Build;
import replicatorg.model.BuildElement;

public class EditorHeader
extends BGPanel
implements ActionListener {
    private ButtonGroup tabGroup = new ButtonGroup();
    static Color backgroundColor;
    static Color textSelectedColor;
    static Color textUnselectedColor;
    private ChangeListener changeListener;
    static BufferedImage selectedTabBg;
    static BufferedImage regularTabBg;
    JLabel titleLabel = new JLabel("Untitled");
    MainWindow editor;
    int fontAscent;
    int menuLeft;
    int menuRight;

    public BuildElement getSelectedElement() {
        Enumeration<AbstractButton> e = this.tabGroup.getElements();
        while (e.hasMoreElements()) {
            TabButton tb = (TabButton)e.nextElement();
            if (!tb.isSelected()) continue;
            return tb.getBuildElement();
        }
        return null;
    }

    void setChangeListener(ChangeListener listener) {
        this.changeListener = listener;
    }

    protected void initTabImages() {
        if (selectedTabBg == null) {
            selectedTabBg = Base.getImage("images/tab-selected.png", this);
        }
        if (regularTabBg == null) {
            regularTabBg = Base.getImage("images/tab-regular.png", this);
        }
    }

    public EditorHeader(MainWindow mainWindow) {
        this.initTabImages();
        this.setBorder(null);
        this.setLayout((LayoutManager)new MigLayout("ins 0 10 0 10,gap 10 10 0 0"));
        this.editor = mainWindow;
        this.add(this.titleLabel);
        backgroundColor = new Color(146, 160, 107);
        textSelectedColor = Base.getColorPref("header.text.selected.color", "#1A1A00");
        textUnselectedColor = Base.getColorPref("header.text.unselected.color", "#ffffff");
        this.setBackground(backgroundColor);
    }

    private void removeTabs() {
        this.tabGroup = new ButtonGroup();
        int i = 0;
        while (i < this.getComponentCount()) {
            if (this.getComponent(i) instanceof TabButton) {
                this.remove(i);
                this.removeTabs();
                return;
            }
            ++i;
        }
        this.validate();
    }

    private void addTabForElement(Build build, BuildElement element) {
        TabButton tb = new TabButton(element);
        this.add(tb);
        if (build.getOpenedElement() == element) {
            tb.doClick();
        }
    }

    void setBuild(Build build) {
        this.removeTabs();
        if (build.getModel() != null) {
            this.addTabForElement(build, build.getModel());
        }
        if (build.getCode() != null) {
            this.addTabForElement(build, build.getCode());
        }
        this.titleLabel.setText(build.getName());
        this.validate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent a) {
        ChangeEvent e = new ChangeEvent(this);
        if (this.changeListener != null) {
            this.changeListener.stateChanged(e);
        }
    }

    private class TabButton
    extends JToggleButton
    implements BuildElement.Listener {
        final WeakReference<BuildElement> element;

        public BuildElement getBuildElement() {
            return (BuildElement)this.element.get();
        }

        public TabButton(BuildElement element) {
            this.buildElementUpdate(element);
            this.element = new WeakReference<BuildElement>(element);
            this.setUI(new TabButtonUI());
            this.setBorder(new EmptyBorder(6, 8, 8, 10));
            EditorHeader.this.tabGroup.add(this);
            this.addActionListener(EditorHeader.this);
            element.addListener(this);
        }

        @Override
        public void buildElementUpdate(BuildElement element) {
            if (element.isModified()) {
                this.setText(String.valueOf(element.getType().getDisplayString()) + "*");
                this.setFont(this.getFont().deriveFont(1));
            } else {
                this.setText(element.getType().getDisplayString());
                this.setFont(this.getFont().deriveFont(0));
            }
            this.repaint();
        }
    }

    private class TabButtonUI
    extends BasicButtonUI {
        private TabButtonUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            EditorHeader.this.initTabImages();
            TabButton b = (TabButton)c;
            BufferedImage img = b.isSelected() ? selectedTabBg : regularTabBg;
            int partWidth = img.getWidth() / 3;
            int height = img.getHeight();
            boolean x = false;
            boolean y = false;
            int w = c.getWidth();
            g.drawImage(img, 0, 0, 0 + partWidth, 0 + height, 0, 0, partWidth, height, null);
            int rightTabStart = img.getWidth() - partWidth;
            g.drawImage(img, 0 + partWidth, 0, 0 + w - partWidth, 0 + height, partWidth, 0, rightTabStart, height, null);
            g.drawImage(img, 0 + w - partWidth, 0, 0 + w, 0 + height, rightTabStart, 0, img.getWidth(), height, null);
            b.setForeground(b.isSelected() ? textSelectedColor : textUnselectedColor);
            super.paint(g, c);
        }
    }
}

