/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.LayoutManager;
import java.io.StringWriter;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.drivers.Driver;
import replicatorg.drivers.OnboardParameters;
import replicatorg.machine.MachineFactory;

public class InfoPanel
extends JFrame {
    JTextArea infoArea;

    public InfoPanel() {
        super("About this Makerbot");
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        this.infoArea = new JTextArea("ReplicatorG:", 40, 60);
        panel.add(this.infoArea);
        this.add(panel);
        this.pack();
        this.infoArea.setText(this.getMachineInfo());
    }

    public static String convertNodeToHtml(Node node) {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            t.transform(new DOMSource(node), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public String getMachineInfo() {
        Driver driver = Base.getMachineLoader().getDriver();
        String info = new String();
        info = String.valueOf(info) + "System Information\n";
        info = String.valueOf(info) + " ReplicatorG version: " + Base.VERSION_NAME + "\n";
        info = String.valueOf(info) + " Java version: " + System.getProperty("java.version") + "\n";
        info = String.valueOf(info) + "\n";
        info = String.valueOf(info) + "Machine\n";
        info = String.valueOf(info) + " Profile Name: " + Base.preferences.get("machine.name", "") + "\n";
        info = String.valueOf(info) + " Driver Type: " + Base.getMachineLoader().getDriver().getDriverName() + "\n";
        info = String.valueOf(info) + " Name: " + Base.getMachineLoader().getMachine().getMachineName() + "\n";
        info = String.valueOf(info) + " Motherboard firmware version: " + driver.getFirmwareInfo() + "\n";
        if (driver instanceof OnboardParameters) {
            OnboardParameters.CommunicationStatistics stats = ((OnboardParameters)((Object)driver)).getCommunicationStatistics();
            info = String.valueOf(info) + " Motherboard communication statistics\n";
            info = String.valueOf(info) + "  Number of packets received from the USB interface:" + stats.packetCount + "\n";
            info = String.valueOf(info) + "  Number of packets sent over the RS485 interface:" + stats.sentPacketCount + "\n";
            info = String.valueOf(info) + "  Number of packets sent over the RS485 interface that were not responded to:" + stats.packetFailureCount + "\n";
            info = String.valueOf(info) + "  Number of packet retries attempted:" + stats.packetRetryCount + "\n";
            info = String.valueOf(info) + "  Number of bytes received over the RS485 interface that were discarded as noise:" + stats.noiseByteCount + "\n";
        }
        info = String.valueOf(info) + "\n";
        info = String.valueOf(info) + "Machine Driver XML:\n";
        Node machineNode = MachineFactory.getMachineNode(Base.preferences.get("machine.name", ""));
        if (machineNode != null) {
            info = String.valueOf(info) + InfoPanel.convertNodeToHtml(machineNode) + "\n";
        }
        return info;
    }
}

