/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.modeling;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.media.j3d.Transform3D;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.vecmath.Vector3d;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.modeling.PreviewPanel;
import replicatorg.app.ui.modeling.Tool;
import replicatorg.app.ui.modeling.ToolPanel;

public class MoveTool
extends Tool {
    Transform3D vt;
    JCheckBox lockZ;
    JFormattedTextField transX;
    JFormattedTextField transY;
    JFormattedTextField transZ;

    public MoveTool(ToolPanel parent) {
        super(parent);
    }

    @Override
    public Icon getButtonIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Move";
    }

    @Override
    public JPanel getControls() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("fillx,filly"));
        JButton centerButton = this.createToolButton("Center", "images/center-object.png");
        centerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MoveTool.this.parent.getModel().center();
            }
        });
        p.add((Component)centerButton, "growx,wrap");
        JButton lowerButton = this.createToolButton("Put on platform", "images/center-object.png");
        lowerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MoveTool.this.parent.getModel().putOnPlatform();
            }
        });
        p.add((Component)lowerButton, "growx,wrap");
        this.transX = new JFormattedTextField(NumberFormat.getInstance());
        this.transY = new JFormattedTextField(NumberFormat.getInstance());
        this.transZ = new JFormattedTextField(NumberFormat.getInstance());
        this.transX.setValue(10);
        this.transY.setValue(10);
        this.transZ.setValue(10);
        JButton transXplus = new JButton("X+");
        JButton transYplus = new JButton("Y+");
        JButton transZplus = new JButton("Z+");
        JButton transXminus = new JButton("X-");
        JButton transYminus = new JButton("Y-");
        JButton transZminus = new JButton("Z-");
        p.add(transXminus);
        p.add((Component)this.transX, "growx");
        p.add((Component)transXplus, "wrap");
        p.add(transYminus);
        p.add((Component)this.transY, "growx");
        p.add((Component)transYplus, "wrap");
        p.add(transZminus);
        p.add((Component)this.transZ, "growx");
        p.add((Component)transZplus, "wrap");
        transXplus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String txt = MoveTool.this.transX.getText();
                if (txt != null) {
                    try {
                        double transXval = Double.parseDouble(txt);
                        MoveTool.this.parent.getModel().translateObject(transXval, 0.0, 0.0);
                    }
                    catch (Exception e) {
                        Base.logger.fine("Problem parsing number or translating object.");
                    }
                }
            }
        });
        transXminus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String txt = MoveTool.this.transX.getText();
                if (txt != null) {
                    try {
                        double transXval = Double.parseDouble(txt);
                        MoveTool.this.parent.getModel().translateObject(-transXval, 0.0, 0.0);
                    }
                    catch (Exception e) {
                        Base.logger.fine("Problem parsing number or translating object.");
                    }
                }
            }
        });
        transYplus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String txt = MoveTool.this.transY.getText();
                if (txt != null) {
                    try {
                        double transYval = Double.parseDouble(txt);
                        MoveTool.this.parent.getModel().translateObject(0.0, transYval, 0.0);
                    }
                    catch (Exception e) {
                        Base.logger.fine("Problem parsing number or translating object.");
                    }
                }
            }
        });
        transYminus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String txt = MoveTool.this.transY.getText();
                if (txt != null) {
                    try {
                        double transYval = Double.parseDouble(txt);
                        MoveTool.this.parent.getModel().translateObject(0.0, -transYval, 0.0);
                    }
                    catch (Exception e) {
                        Base.logger.fine("Problem parsing number or translating object.");
                    }
                }
            }
        });
        transZplus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String txt = MoveTool.this.transZ.getText();
                if (txt != null) {
                    try {
                        double transZval = Double.parseDouble(txt);
                        MoveTool.this.parent.getModel().translateObject(0.0, 0.0, transZval);
                    }
                    catch (Exception e) {
                        Base.logger.fine("Problem parsing number or translating object.");
                    }
                }
            }
        });
        transZminus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String txt = MoveTool.this.transZ.getText();
                if (txt != null) {
                    try {
                        double transZval = Double.parseDouble(txt);
                        MoveTool.this.parent.getModel().translateObject(0.0, 0.0, -transZval);
                    }
                    catch (Exception e) {
                        Base.logger.fine("Problem parsing number or translating object.");
                    }
                }
            }
        });
        this.lockZ = new JCheckBox("Lock height");
        p.add((Component)this.lockZ, "growx,wrap");
        return p;
    }

    @Override
    public String getInstructions() {
        return Base.isMacOS() ? "<html><body>Drag to move object<br>Shift-drag to rotate view<br>Mouse wheel to zoom</body></html>" : "<html><body>Left drag to move object<br>Right drag to rotate view<br>Mouse wheel to zoom</body></html>";
    }

    @Override
    public String getTitle() {
        return "Move Object";
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startPoint == null) {
            return;
        }
        Point p = e.getPoint();
        PreviewPanel.DragMode mode = PreviewPanel.DragMode.NONE;
        if (Base.isMacOS()) {
            if (this.button == 1 && !e.isShiftDown()) {
                mode = PreviewPanel.DragMode.TRANSLATE_OBJECT;
            }
        } else if (this.button == 1) {
            mode = PreviewPanel.DragMode.TRANSLATE_OBJECT;
        }
        double xd = p.x - this.startPoint.x;
        double yd = -((double)(p.y - this.startPoint.y));
        switch (mode) {
            case NONE: {
                super.mouseDragged(e);
                break;
            }
            case TRANSLATE_OBJECT: {
                this.doTranslate(xd, yd);
            }
        }
        this.startPoint = p;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.vt = this.parent.preview.getViewTransform();
        super.mousePressed(e);
    }

    void doTranslate(double deltaX, double deltaY) {
        Vector3d v = new Vector3d(deltaX, deltaY, 0.0);
        this.vt.transform(v);
        if (this.lockZ.isSelected()) {
            v.z = 0.0;
        }
        this.parent.getModel().translateObject(v.x, v.y, v.z);
    }
}

