/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.modeling;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.modeling.PreviewPanel;
import replicatorg.app.ui.modeling.Tool;
import replicatorg.app.ui.modeling.ToolPanel;

public class ScalingTool
extends Tool {
    boolean isOnPlatform = false;
    double scaleDragChange = 1.0;
    JTextField scaleFactor;

    public ScalingTool(ToolPanel parent) {
        super(parent);
    }

    @Override
    Icon getButtonIcon() {
        return null;
    }

    @Override
    String getButtonName() {
        return "Scale";
    }

    @Override
    JPanel getControls() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("fillx,filly,gap 0"));
        this.scaleFactor = new JFormattedTextField(NumberFormat.getInstance());
        this.scaleFactor.setText("1.00");
        p.add((Component)this.scaleFactor, "growx");
        JButton b = new JButton("Scale");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String txt = ScalingTool.this.scaleFactor.getText();
                if (txt != null) {
                    try {
                        double scale = Double.parseDouble(txt);
                        ScalingTool.this.parent.getModel().scale(scale, ScalingTool.this.parent.getModel().isOnPlatform());
                    }
                    catch (NumberFormatException nfe) {
                        Base.logger.fine("Scale factor " + txt + " is not parseable");
                    }
                }
            }
        });
        p.add((Component)b, "growx,wrap");
        b = this.createToolButton("inches->mm", "images/center-object.png");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScalingTool.this.parent.getModel().scale(25.4, ScalingTool.this.parent.getModel().isOnPlatform());
                double currentScale = ScalingTool.this.parent.getModel().model.getTransform().getScale();
                ScalingTool.this.scaleFactor.setText(String.valueOf((double)((int)(100.0 * currentScale)) / 100.0));
            }
        });
        p.add((Component)b, "growx,wrap");
        b = this.createToolButton("mm->inches", "images/center-object.png");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScalingTool.this.parent.getModel().scale(0.03937007874015748, ScalingTool.this.parent.getModel().isOnPlatform());
                double currentScale = ScalingTool.this.parent.getModel().model.getTransform().getScale();
                ScalingTool.this.scaleFactor.setText(String.valueOf((double)((int)(100.0 * currentScale)) / 100.0));
            }
        });
        p.add((Component)b, "growx,wrap");
        return p;
    }

    @Override
    public String getInstructions() {
        return Base.isMacOS() ? "<html><body>Drag to scale object<br>Shift-drag to rotate view<br>Mouse wheel to zoom</body></html>" : "<html><body>Left drag to scale object<br>Right drag to rotate view<br>Mouse wheel to zoom</body></html>";
    }

    @Override
    String getTitle() {
        return "Scale object";
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.isOnPlatform = this.parent.getModel().isOnPlatform();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.scaleDragChange = 1.0;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startPoint == null) {
            return;
        }
        Point p = e.getPoint();
        PreviewPanel.DragMode mode = PreviewPanel.DragMode.NONE;
        if (Base.isMacOS()) {
            if (this.button == 1 && !e.isShiftDown()) {
                mode = PreviewPanel.DragMode.SCALE_OBJECT;
            }
        } else if (this.button == 1) {
            mode = PreviewPanel.DragMode.SCALE_OBJECT;
        }
        double xd = p.x - this.startPoint.x;
        double yd = -((double)(p.y - this.startPoint.y));
        switch (mode) {
            case NONE: {
                super.mouseDragged(e);
                break;
            }
            case SCALE_OBJECT: {
                this.scaleDragChange += 0.01 * (xd + yd) * this.scaleDragChange;
                double currentScale = this.parent.getModel().model.getTransform().getScale();
                double targetScale = this.scaleDragChange / currentScale;
                this.parent.getModel().scale(targetScale, this.isOnPlatform);
                this.scaleFactor.setText(String.valueOf((double)((int)(100.0 * this.scaleDragChange)) / 100.0));
            }
        }
        this.startPoint = p;
    }
}

