/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.modeling;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3d;
import replicatorg.app.Base;
import replicatorg.app.ui.modeling.PreviewPanel;
import replicatorg.app.ui.modeling.ToolPanel;

public abstract class Tool
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    protected final ToolPanel parent;
    protected Point startPoint = null;
    protected int button = 0;

    public JButton createToolButton(String text, String iconPath) {
        JButton button = new JButton(text);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        return button;
    }

    abstract String getTitle();

    abstract String getButtonName();

    abstract Icon getButtonIcon();

    abstract String getInstructions();

    abstract JPanel getControls();

    public Tool(ToolPanel parent) {
        this.parent = parent;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.startPoint == null) {
            return;
        }
        Point p = e.getPoint();
        PreviewPanel.DragMode mode = PreviewPanel.DragMode.ROTATE_VIEW;
        if (Base.isMacOS()) {
            if (this.button == 1 && !e.isShiftDown()) {
                mode = PreviewPanel.DragMode.ROTATE_VIEW;
            } else if (this.button == 1 && e.isShiftDown()) {
                mode = PreviewPanel.DragMode.ROTATE_VIEW;
            }
        } else if (this.button == 1) {
            mode = PreviewPanel.DragMode.ROTATE_VIEW;
        } else if (this.button == 3) {
            mode = PreviewPanel.DragMode.ROTATE_VIEW;
        }
        double xd = p.x - this.startPoint.x;
        double yd = p.y - this.startPoint.y;
        switch (mode) {
            case ROTATE_VIEW: {
                this.parent.preview.adjustViewAngle(-0.05 * xd, -0.05 * yd);
                break;
            }
            case TRANSLATE_VIEW: {
                this.parent.preview.adjustViewTranslation(-0.5 * xd, 0.5 * yd);
            }
        }
        this.startPoint = p;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.parent.getModel().startDrag();
        this.startPoint = e.getPoint();
        this.button = e.getButton();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.parent.getModel().endDrag();
        this.startPoint = null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        this.parent.preview.adjustZoom(10.0 * (double)notches);
    }

    public class AxisControl {
        SpinnerNumberModel model;
        JSpinner spinner;
        JCheckBox box;

        public AxisControl(String title, JPanel parent, double initial) {
            this.model = new SpinnerNumberModel(initial, -100000.0, 100000.0, 1.0);
            this.spinner = new JSpinner(this.model);
            this.box = new JCheckBox("lock");
            parent.add(new JLabel(title));
            parent.add((Component)this.spinner, "growx");
            parent.add((Component)this.box, "wrap");
            if (Tool.this instanceof ChangeListener) {
                this.spinner.addChangeListener((ChangeListener)((Object)Tool.this));
            }
        }
    }

    public class CoordinateControl {
        AxisControl[] axes = new AxisControl[3];
        Point3d coordinate;

        public CoordinateControl(JPanel parent, Point3d coordinate) {
            if (coordinate == null) {
                coordinate = new Point3d();
            }
            this.coordinate = coordinate;
            this.axes[0] = new AxisControl("X", parent, coordinate.x);
            this.axes[1] = new AxisControl("Y", parent, coordinate.y);
            this.axes[2] = new AxisControl("Z", parent, coordinate.z);
        }

        public void update() {
            this.axes[0].model.setValue(new Double(this.coordinate.x));
            this.axes[1].model.setValue(new Double(this.coordinate.y));
            this.axes[2].model.setValue(new Double(this.coordinate.z));
        }
    }
}

