/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.util;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import replicatorg.app.Base;

public class PythonUtils {
    static final String PYTON_PATH_PREF = "python.default_path";
    private static Selector selector = null;
    static String pythonPath = null;
    static Version pythonVersion = null;

    public static void setSelector(Selector selector) {
        PythonUtils.selector = selector;
    }

    public static String getPythonPath() {
        return PythonUtils.getPythonPath(null, null);
    }

    public static String getPythonPath(Version minVersion, Version maxVersion) {
        File candidate;
        boolean versionOk = false;
        if (pythonVersion != null) {
            versionOk = true;
            if (minVersion != null && pythonVersion.compareTo(minVersion) < 0) {
                versionOk = false;
            }
            if (maxVersion != null && maxVersion.compareTo(pythonVersion) < 0) {
                versionOk = false;
            }
        }
        if (versionOk && pythonPath != null) {
            return pythonPath;
        }
        pythonPath = null;
        pythonVersion = null;
        TreeSet<String> candidates = new TreeSet<String>();
        String path = Base.preferences.get(PYTON_PATH_PREF, null);
        if (path != null && (candidate = new File(path)).exists()) {
            candidates.add(candidate.getAbsolutePath());
        }
        String[] paths = System.getenv("PATH").split(File.pathSeparator);
        String[] pythonNames = new String[]{"python", "python2"};
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path2 = stringArray[n2];
            String[] stringArray2 = pythonNames;
            int n3 = pythonNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray2[n4];
                File candidate2 = new File(path2, name);
                if (candidate2.exists()) {
                    candidates.add(candidate2.getAbsolutePath());
                }
                ++n4;
            }
            ++n2;
        }
        if (Base.isWindows()) {
            Pattern pythonPat = Pattern.compile("Python([0-9]+)");
            File driveDir = new File("C:/");
            if (driveDir.exists() && driveDir.isDirectory()) {
                String[] stringArray3 = driveDir.list();
                int n5 = stringArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    File python;
                    String path3 = stringArray3[n6];
                    Matcher match = pythonPat.matcher(path3);
                    if (match.matches() && (python = new File(new File(driveDir, path3), "python.exe")).exists()) {
                        candidates.add(python.getAbsolutePath());
                    }
                    ++n6;
                }
            }
        }
        for (String c : candidates) {
            Version version = PythonUtils.checkVersion(c, minVersion, maxVersion);
        }
        Vector<String> viableCandidates = new Vector<String>();
        for (String candidate3 : candidates) {
            Version v = PythonUtils.checkVersion(candidate3, minVersion, maxVersion);
            if (v == null) continue;
            viableCandidates.add(candidate3);
        }
        if (selector != null && viableCandidates.size() > 1) {
            String path4 = selector.selectPythonPath(viableCandidates);
            if (path4 != null) {
                Base.preferences.put(PYTON_PATH_PREF, path4);
                pythonPath = path4;
                pythonVersion = PythonUtils.checkVersion(pythonPath);
            }
        } else if (viableCandidates.size() > 0) {
            pythonPath = (String)viableCandidates.firstElement();
            pythonVersion = PythonUtils.checkVersion(pythonPath);
        }
        return pythonPath;
    }

    public static Version checkVersion(String path, Version minVersion, Version maxVersion) {
        Version v = PythonUtils.checkVersion(path);
        if (v != null) {
            if (minVersion != null && v.compareTo(minVersion) < 0) {
                return null;
            }
            if (maxVersion != null && v.compareTo(maxVersion) > 0) {
                return null;
            }
        }
        return v;
    }

    public static Version checkVersion() {
        if (PythonUtils.getPythonPath() == null) {
            return null;
        }
        return PythonUtils.checkVersion(PythonUtils.getPythonPath());
    }

    public static Version checkVersion(String path) {
        BufferedReader reader;
        block5: {
            ProcessBuilder pb = new ProcessBuilder(path, "-V");
            pb.redirectErrorStream(true);
            Process p = pb.start();
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int returnCode = p.waitFor();
            if (returnCode == 0) break block5;
            return null;
        }
        try {
            String line = reader.readLine();
            Pattern pattern = Pattern.compile("Python ([0-9]+)\\.([0-9]+)(?:\\.([0-9]+))?");
            while (line != null) {
                Matcher m = pattern.matcher(line);
                if (m.find()) {
                    int major = Integer.parseInt(m.group(1));
                    int minor = Integer.parseInt(m.group(2));
                    int revision = m.group(3) != null ? Integer.parseInt(m.group(3)) : 0;
                    return new Version(major, minor, revision);
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            Base.logger.log(Level.SEVERE, "Error attempting to detect python", e);
        }
        return null;
    }

    public static boolean checkTkInter() {
        if (PythonUtils.getPythonPath() == null) {
            return false;
        }
        ProcessBuilder pb = new ProcessBuilder(PythonUtils.getPythonPath(), "-c", "import Tkinter");
        try {
            Process p = pb.start();
            int returnCode = p.waitFor();
            if (returnCode != 0) {
                return false;
            }
        }
        catch (Exception e) {
            Base.logger.log(Level.SEVERE, "Error attempting to detect TkInter", e);
        }
        return true;
    }

    public static boolean interactiveCheckTkInter(Frame parent, String procedureName) {
        boolean hasTkInter = PythonUtils.checkTkInter();
        if (procedureName == null) {
            procedureName = "This operation";
        }
        if (!hasTkInter) {
            String s = String.valueOf(procedureName) + " requires TkInter to be installed.  No valid TkInter install was found.";
            PythonUtils.notifyUser(parent, s);
        }
        return hasTkInter;
    }

    public static boolean interactiveCheckVersion(Frame parent, String procedureName, Version min, Version max) {
        PythonUtils.getPythonPath(min, max);
        Version v = pythonVersion;
        if (procedureName == null) {
            procedureName = "This operation";
        }
        if (v != null) {
            if (min != null && min.compareTo(v) == 1) {
                PythonUtils.notifyUser(parent, String.valueOf(procedureName) + " requires Python version " + min.toString() + " or later.  Python version " + v.toString() + " was detected.");
                return false;
            }
            if (max != null && max.compareTo(v) != 1) {
                System.err.println("Comparing " + max.toString() + " to " + v.toString());
                System.err.println("Returned " + Integer.toString(max.compareTo(v)));
                PythonUtils.notifyUser(parent, String.valueOf(procedureName) + " requires a version of Python earlier than version " + max.toString() + ".  Python version " + v.toString() + " was detected.");
                return false;
            }
            return true;
        }
        PythonUtils.notifyUser(parent, String.valueOf(procedureName) + " requires that a Python interpreter be installed.");
        return false;
    }

    private static void notifyUser(final Frame parent, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Base.isLinux()) {
                    String s = "<html><p>" + message + "</p><p>Make sure your system has the 'python' and 'python-tk' packages installed.</p></html>";
                    JOptionPane.showMessageDialog(parent, s, "Missing or incorrect Python interpreter detected", 0);
                } else {
                    String s = "<html><p>" + message + "</p><p>Would you like to visit the Python download page now?</p></html>";
                    int rsp = JOptionPane.showConfirmDialog(parent, s, "Missing or incorrect Python interpreter detected", 0, 0);
                    if (rsp == 0) {
                        Base.openURL("http://python.org/download");
                    }
                }
            }
        });
    }

    public static void setPythonPath(String path) {
        Base.preferences.put(PYTON_PATH_PREF, path);
        pythonPath = path;
    }

    public static interface Selector {
        public String selectPythonPath(Vector<String> var1);
    }

    public static class Version
    implements Comparable<Version> {
        public int major;
        public int minor;
        public int revision;

        public Version(int major, int minor, int revision) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
        }

        @Override
        public int compareTo(Version other) {
            if (this.major < other.major) {
                return -1;
            }
            if (this.major > other.major) {
                return 1;
            }
            if (this.minor < other.minor) {
                return -1;
            }
            if (this.minor > other.minor) {
                return 1;
            }
            if (this.revision < other.revision) {
                return -1;
            }
            if (this.revision > other.revision) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(Integer.toString(this.major)) + "." + Integer.toString(this.minor) + "." + Integer.toString(this.revision);
        }
    }
}

