/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine;

import java.util.LinkedList;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.GCodeParser;
import replicatorg.drivers.Driver;
import replicatorg.drivers.DriverQueryInterface;
import replicatorg.drivers.EstimationDriver;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.SimulationDriver;
import replicatorg.drivers.StopException;
import replicatorg.drivers.commands.DriverCommand;
import replicatorg.machine.MachineCallbackHandler;
import replicatorg.machine.MachineCommand;
import replicatorg.machine.MachineInterface;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineThread;
import replicatorg.machine.MachineToolStatusEvent;
import replicatorg.machine.model.MachineModel;
import replicatorg.machine.model.ToolModel;
import replicatorg.model.GCodeSource;

public class Machine
implements MachineInterface {
    MachineThread machineThread;
    final MachineCallbackHandler callbackHandler;
    protected Node machineNode;

    @Override
    public MachineState getMachineState() {
        return this.machineThread.getMachineState();
    }

    @Override
    public String getMachineName() {
        return this.machineThread.getMachineName();
    }

    public Machine(Node mNode, MachineCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        this.machineNode = mNode;
        this.machineThread = new MachineThread(this, mNode);
        this.machineThread.start();
    }

    @Override
    public boolean buildRemote(String remoteName) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_REMOTE, null, remoteName));
        return true;
    }

    @Override
    public boolean buildDirect(GCodeSource source) {
        Base.logger.info("Estimating build time...");
        this.estimate(source);
        Base.logger.info("Beginning build.");
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_DIRECT, source, null));
        return true;
    }

    @Override
    public void simulate(GCodeSource source) {
        Base.logger.info("Estimating build time...");
        this.estimate(source);
        Base.logger.info("Beginning simulation.");
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.SIMULATE, source, null));
    }

    @Override
    public void estimate(GCodeSource source) {
        if (source == null) {
            return;
        }
        EstimationDriver estimator = new EstimationDriver();
        estimator.setMachine(this.machineThread.getModel());
        LinkedList<DriverCommand> estimatorQueue = new LinkedList<DriverCommand>();
        GCodeParser estimatorParser = new GCodeParser();
        estimatorParser.init(estimator);
        for (String line : source) {
            estimatorParser.parse(line, estimatorQueue);
            for (DriverCommand command : estimatorQueue) {
                try {
                    command.run(estimator);
                }
                catch (RetryException retryException) {
                }
                catch (StopException stopException) {
                    // empty catch block
                }
            }
            estimatorQueue.clear();
        }
        this.machineThread.setEstimatedBuildTime(estimator.getBuildTime());
        Base.logger.info("Estimated build time is: " + EstimationDriver.getBuildTimeString(estimator.getBuildTime()));
    }

    @Override
    public DriverQueryInterface getDriverQueryInterface() {
        return (DriverQueryInterface)((Object)this.machineThread.getDriver());
    }

    @Override
    public Driver getDriver() {
        return this.machineThread.getDriver();
    }

    @Override
    public SimulationDriver getSimulatorDriver() {
        return this.machineThread.getSimulator();
    }

    @Override
    public MachineModel getModel() {
        return this.machineThread.getModel();
    }

    @Override
    public void stopMotion() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.STOP_MOTION, null, null));
    }

    @Override
    public void stopAll() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.STOP_ALL, null, null));
    }

    @Override
    public synchronized boolean isConnected() {
        return this.machineThread.isConnected();
    }

    @Override
    public void pause() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.PAUSE, null, null));
    }

    @Override
    public void upload(GCodeSource source, String remoteName) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_TO_REMOTE_FILE, source, remoteName));
    }

    @Override
    public void buildToFile(GCodeSource source, String path) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.BUILD_TO_FILE, source, path));
    }

    @Override
    public void unpause() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.UNPAUSE, null, null));
    }

    @Override
    public void reset() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.RESET, null, null));
    }

    @Override
    public void connect(String portName) {
        if (!this.machineThread.isAlive()) {
            this.machineThread = new MachineThread(this, this.machineNode);
            this.machineThread.start();
        }
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.CONNECT, null, portName));
    }

    @Override
    public synchronized void disconnect() {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.DISCONNECT, null, null));
    }

    @Override
    public synchronized boolean isPaused() {
        return this.getMachineState().isPaused();
    }

    @Override
    public void runCommand(DriverCommand command) {
        this.machineThread.scheduleRequest(new MachineCommand(RequestType.RUN_COMMAND, command));
    }

    @Override
    public void dispose() {
        if (this.machineThread != null) {
            this.machineThread.scheduleRequest(new MachineCommand(RequestType.SHUTDOWN, null, null));
            try {
                this.machineThread.join(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void emitStateChange(MachineState current, String message) {
        MachineStateChangeEvent e = new MachineStateChangeEvent(this, current, message);
        this.callbackHandler.schedule(e);
    }

    protected void emitProgress(MachineProgressEvent progress) {
        this.callbackHandler.schedule(progress);
    }

    protected void emitToolStatus(ToolModel tool) {
        MachineToolStatusEvent e = new MachineToolStatusEvent(this, tool);
        this.callbackHandler.schedule(e);
    }

    @Override
    public int getLinesProcessed() {
        return this.machineThread.getLinesProcessed();
    }

    @Override
    public boolean isSimulating() {
        return this.machineThread.isSimulating();
    }

    @Override
    public boolean isInteractiveTarget() {
        return this.machineThread.isInteractiveTarget();
    }

    @Override
    public JobTarget getTarget() {
        return this.machineThread.getTarget();
    }

    public static enum JobTarget {
        NONE,
        SIMULATOR,
        MACHINE,
        REMOTE_FILE,
        FILE;

    }

    public static enum RequestType {
        CONNECT,
        DISCONNECT,
        DISCONNECT_REMOTE_BUILD,
        RESET,
        SIMULATE,
        BUILD_DIRECT,
        BUILD_TO_FILE,
        BUILD_TO_REMOTE_FILE,
        BUILD_REMOTE,
        PAUSE,
        UNPAUSE,
        STOP_MOTION,
        STOP_ALL,
        RUN_COMMAND,
        SHUTDOWN;

    }
}

