/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import replicatorg.app.Base;
import replicatorg.machine.Machine;
import replicatorg.machine.MachineCallbackHandler;

public class MachineFactory {
    private static MachineMap machineMap = null;

    private MachineFactory() {
        throw new AssertionError();
    }

    public static Machine load(String name, MachineCallbackHandler callbackHandler) {
        Node machineNode = MachineFactory.getMachineNode(name);
        if (machineNode == null) {
            return null;
        }
        return new Machine(machineNode, callbackHandler);
    }

    public static Machine loadSimulator() {
        return MachineFactory.load("3-Axis Simulator", new MachineCallbackHandler());
    }

    public static Vector<String> getMachineNames() {
        Vector<String> v = new Vector<String>();
        boolean showExperimental = Base.preferences.getBoolean("machine.showExperimental", false);
        MachineMap mm = MachineFactory.getMachineMap();
        for (Map.Entry entry : mm.entrySet()) {
            String exp;
            if (!showExperimental && (exp = ((Element)entry.getValue()).getAttribute("experimental")).length() != 0 && !exp.equals("0")) continue;
            v.add((String)entry.getKey());
        }
        Collections.sort(v);
        return v;
    }

    private static MachineMap getMachineMap() {
        if (machineMap == null) {
            machineMap = MachineFactory.loadMachinesConfig();
        }
        return machineMap;
    }

    public static Node getMachineNode(String name) {
        MachineMap mm = MachineFactory.getMachineMap();
        if (mm.containsKey(name)) {
            return (Node)mm.get(name);
        }
        return null;
    }

    private static void addMachinesForDocument(Document dom, MachineMap map) {
        NodeList nl = dom.getElementsByTagName("machine");
        int i = 0;
        while (i < nl.getLength()) {
            Element e = (Element)nl.item(i);
            NodeList names = e.getElementsByTagName("name");
            if (names != null && names.getLength() > 0) {
                String mname = names.item(0).getTextContent().trim();
                Base.logger.log(Level.FINE, "Adding machine " + mname + " for node " + e.toString());
                map.put(mname, e);
            }
            ++i;
        }
    }

    private static void addMachinesForDirectory(File dir, MachineMap machineMap, DocumentBuilder db) {
        try {
            db.reset();
        }
        catch (UnsupportedOperationException uoe) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                Base.logger.log(Level.SEVERE, "Could not create document builder", e);
            }
        }
        List<String> filenames = Arrays.asList(dir.list());
        Collections.sort(filenames);
        for (String filename : filenames) {
            File f;
            if (!filename.endsWith(".xml") && !filename.endsWith(".XML") || !(f = new File(dir, filename)).exists() || !f.isFile()) continue;
            Base.logger.log(Level.FINE, "Scanning file " + filename);
            try {
                Document d = db.parse(f);
                MachineFactory.addMachinesForDocument(d, machineMap);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static MachineMap loadMachinesConfig() {
        MachineMap machineMap = new MachineMap();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            File f = Base.getApplicationFile("machines");
            if (f.exists() && f.isDirectory()) {
                MachineFactory.addMachinesForDirectory(f, machineMap, db);
            }
            if ((f = Base.getUserFile("machines", false)).exists() && f.isDirectory()) {
                MachineFactory.addMachinesForDirectory(f, machineMap, db);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return machineMap;
    }

    static class MachineMap
    extends HashMap<String, Element> {
        MachineMap() {
        }
    }
}

