/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine;

import replicatorg.app.Base;
import replicatorg.drivers.Driver;
import replicatorg.machine.MachineCallbackHandler;
import replicatorg.machine.MachineFactory;
import replicatorg.machine.MachineInterface;
import replicatorg.machine.MachineListener;

public class MachineLoader {
    private MachineInterface machine;
    MachineCallbackHandler callbackHandler = new MachineCallbackHandler();

    public MachineLoader() {
        this.callbackHandler.start();
    }

    public void dispose() {
        if (this.callbackHandler != null) {
            this.callbackHandler.interrupt();
            try {
                this.callbackHandler.join(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public MachineInterface getMachine() {
        return this.machine;
    }

    public boolean isLoaded() {
        return this.machine != null;
    }

    public boolean isConnected() {
        return this.isLoaded() && this.machine.isConnected();
    }

    @Deprecated
    public Driver getDriver() {
        if (!this.isLoaded()) {
            return null;
        }
        return this.machine.getDriver();
    }

    public boolean load(String machineType) {
        if (this.isLoaded()) {
            this.machine.dispose();
        }
        this.machine = MachineFactory.load(machineType, this.callbackHandler);
        if (this.machine == null) {
            Base.logger.severe("Unable to connect to machine!");
            return false;
        }
        return true;
    }

    public void unload() {
        if (this.isLoaded()) {
            this.machine.dispose();
            this.machine = null;
        }
    }

    public void connect(String port) {
        if (!this.isLoaded()) {
            return;
        }
        this.machine.connect(port);
    }

    public void disconnect() {
        if (this.isLoaded()) {
            this.machine.disconnect();
        }
    }

    public void addMachineListener(MachineListener listener) {
        this.callbackHandler.addMachineListener(listener);
    }

    public void removeMachineListener(MachineListener listener) {
        this.callbackHandler.removeMachineListener(listener);
    }
}

