/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine;

import replicatorg.drivers.EstimationDriver;

public class MachineProgressEvent {
    private double elapsed;
    private double estimated;
    private int lines;
    private int totalLines;

    public MachineProgressEvent(double elapsed, double estimated, int lines, int totalLines) {
        this.elapsed = elapsed;
        this.estimated = estimated;
        this.lines = lines;
        this.totalLines = totalLines;
    }

    public double getElapsed() {
        return this.elapsed;
    }

    public double getEstimated() {
        return this.estimated;
    }

    public int getLines() {
        return this.lines;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public String toString() {
        double proportion = (double)this.lines / (double)this.totalLines;
        StringBuffer buf = new StringBuffer("Commands: ");
        buf.append(String.format("%1$7d / %2$7d", this.lines, this.totalLines));
        buf.append("     |     ");
        buf.append(String.valueOf(String.format("%1$3.2f", (double)Math.round(proportion * 10000.0) / 100.0)) + "%");
        buf.append("     |     Elapsed time: ");
        buf.append(EstimationDriver.getBuildTimeString(this.elapsed, true));
        buf.append("     |     Time remaining: ");
        double remaining = this.estimated * (1.0 - proportion);
        buf.append(EstimationDriver.getBuildTimeString(remaining, true));
        return buf.toString();
    }
}

