/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath;

import java.awt.Frame;
import java.util.LinkedList;
import replicatorg.model.BuildCode;
import replicatorg.model.BuildModel;

public abstract class ToolpathGenerator {
    protected BuildModel model;
    protected LinkedList<GeneratorListener> listeners = new LinkedList();

    public void addListener(GeneratorListener listener) {
        this.listeners.add(listener);
    }

    public void setModel(BuildModel model) {
        this.model = model;
    }

    public boolean visualConfigure(Frame parent) {
        assert (parent != null);
        assert (this.model != null);
        return true;
    }

    public abstract BuildCode generateToolpath();

    public void emitUpdate(String message) {
        for (GeneratorListener listener : this.listeners) {
            listener.updateGenerator(message);
        }
    }

    public void emitCompletion(GeneratorListener.Completion completion, Object details) {
        for (GeneratorListener listener : this.listeners) {
            listener.generationComplete(completion, details);
        }
    }

    public static interface GeneratorListener {
        public void updateGenerator(String var1);

        public void generationComplete(Completion var1, Object var2);

        public static enum Completion {
            SUCCESS,
            FAILURE;

        }
    }
}

