/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import replicatorg.app.Base;
import replicatorg.plugin.toolpath.ToolpathGenerator;
import replicatorg.plugin.toolpath.skeinforge.PrintOMatic;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;

public class ToolpathGeneratorFactory {
    private static Vector<ToolpathGeneratorDescriptor> generatorList = null;

    public static Vector<ToolpathGeneratorDescriptor> getGeneratorList() {
        if (generatorList == null) {
            generatorList = ToolpathGeneratorFactory.buildGeneratorList();
        }
        return generatorList;
    }

    private static Vector<ToolpathGeneratorDescriptor> buildGeneratorList() {
        Vector<ToolpathGeneratorDescriptor> list = new Vector<ToolpathGeneratorDescriptor>();
        class Skeinforge6
        extends SkeinforgeGenerator {
            Skeinforge6() {
            }

            @Override
            public File getDefaultSkeinforgeDir() {
                return Base.getApplicationFile("skein_engines/skeinforge-0006");
            }

            @Override
            public File getUserProfilesDir() {
                return Base.getUserFile("sf_profiles");
            }

            @Override
            public List<SkeinforgeGenerator.SkeinforgePreference> getPreferences() {
                LinkedList<SkeinforgeGenerator.SkeinforgePreference> prefs = new LinkedList<SkeinforgeGenerator.SkeinforgePreference>();
                SkeinforgeGenerator.SkeinforgeBooleanPreference raftPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use raft", "replicatorg.skeinforge.useRaft", true, "If this option is checked, skeinforge will lay down a rectangular 'raft' of plastic before starting the build.  Rafts increase the build size slightly, so you should avoid using a raft if your build goes to the edge of the platform.");
                raftPref.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("Raft", "Activate Raft:", "true"));
                raftPref.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("Raftless", "Activate Raftless:", "false"));
                prefs.add(raftPref);
                return prefs;
            }
        }
        list.add(new ToolpathGeneratorDescriptor("Skeinforge (standard)", "This is the standard version of skeinforge that has shipped with ReplicatorG since 0016.", Skeinforge6.class));
        class Skeinforge40
        extends SkeinforgeGenerator {
            Skeinforge40() {
            }

            @Override
            public File getDefaultSkeinforgeDir() {
                return Base.getApplicationFile("skein_engines/skeinforge-40/skeinforge_application");
            }

            @Override
            public File getUserProfilesDir() {
                return Base.getUserFile("sf_40_profiles");
            }

            @Override
            public List<SkeinforgeGenerator.SkeinforgePreference> getPreferences() {
                LinkedList<SkeinforgeGenerator.SkeinforgePreference> prefs = new LinkedList<SkeinforgeGenerator.SkeinforgePreference>();
                SkeinforgeGenerator.SkeinforgeBooleanPreference raftPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use raft", "replicatorg.skeinforge.useRaft", true, "If this option is checked, skeinforge will lay down a rectangular 'raft' of plastic before starting the build.  Rafts increase the build size slightly, so you should avoid using a raft if your build goes to the edge of the platform.");
                raftPref.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Add Raft, Elevate Nozzle, Orbit:", "true"));
                prefs.add(raftPref);
                SkeinforgeGenerator.SkeinforgeChoicePreference supportPref = new SkeinforgeGenerator.SkeinforgeChoicePreference("Use support material", "replicatorg.skeinforge.choiceSupport", "None", "If this option is selected, skeinforge will attempt to support large overhangs by laying down a support structure that you can later remove.");
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "true"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                prefs.add(supportPref);
                return prefs;
            }
        }
        list.add(new ToolpathGeneratorDescriptor("Skeinforge (40)", "This is the experimental version of skeinforge.", Skeinforge40.class));
        class Skeinforge35
        extends SkeinforgeGenerator {
            Skeinforge35() {
            }

            @Override
            public File getDefaultSkeinforgeDir() {
                return Base.getApplicationFile("skein_engines/skeinforge-35/skeinforge_application");
            }

            @Override
            public File getUserProfilesDir() {
                return Base.getUserFile("sf_35_profiles");
            }

            @Override
            public List<SkeinforgeGenerator.SkeinforgePreference> getPreferences() {
                LinkedList<SkeinforgeGenerator.SkeinforgePreference> prefs = new LinkedList<SkeinforgeGenerator.SkeinforgePreference>();
                SkeinforgeGenerator.SkeinforgeBooleanPreference raftPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use raft", "replicatorg.skeinforge.useRaft", true, "If this option is checked, skeinforge will lay down a rectangular 'raft' of plastic before starting the build.  Rafts increase the build size slightly, so you should avoid using a raft if your build goes to the edge of the platform.");
                raftPref.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Add Raft, Elevate Nozzle, Orbit and Set Altitude:", "true"));
                prefs.add(raftPref);
                SkeinforgeGenerator.SkeinforgeChoicePreference supportPref = new SkeinforgeGenerator.SkeinforgeChoicePreference("Use support material", "replicatorg.skeinforge.choiceSupport", "None", "If this option is selected, skeinforge will attempt to support large overhangs by laying down a support structure that you can later remove.");
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "true"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("None", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "false"));
                supportPref.addOption("Exterior support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "None", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Empty Layers Only", "false"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Everywhere", "true"));
                supportPref.addOption("Full support", new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Exterior Only", "false"));
                prefs.add(supportPref);
                PrintOMatic printOMatic = new PrintOMatic();
                prefs.add(printOMatic);
                return prefs;
            }
        }
        list.add(new ToolpathGeneratorDescriptor("Skeinforge (35)", "This a recent version of skeinforge.", Skeinforge35.class));
        class Skeinforge31
        extends SkeinforgeGenerator {
            Skeinforge31() {
            }

            @Override
            public File getDefaultSkeinforgeDir() {
                return Base.getApplicationFile("skein_engines/skeinforge-31/skeinforge_application");
            }

            @Override
            public File getUserProfilesDir() {
                return Base.getUserFile("sf_31_profiles");
            }

            @Override
            public List<SkeinforgeGenerator.SkeinforgePreference> getPreferences() {
                LinkedList<SkeinforgeGenerator.SkeinforgePreference> prefs = new LinkedList<SkeinforgeGenerator.SkeinforgePreference>();
                SkeinforgeGenerator.SkeinforgeBooleanPreference raftPref = new SkeinforgeGenerator.SkeinforgeBooleanPreference("Use raft", "replicatorg.skeinforge.useRaft", true, "If this option is checked, skeinforge will lay down a rectangular 'raft' of plastic before starting the build.  Rafts increase the build size slightly, so you should avoid using a raft if your build goes to the edge of the platform.");
                raftPref.addNegateableOption(new SkeinforgeGenerator.SkeinforgeOption("raft.csv", "Activate Raft", "true"));
                prefs.add(raftPref);
                return prefs;
            }
        }
        list.add(new ToolpathGeneratorDescriptor("Skeinforge (31)", "This is an old version of skeinforge.", Skeinforge31.class));
        return list;
    }

    public static String getSelectedName() {
        String name = Base.preferences.get("replicatorg.generator.name", "Skeinforge (35)");
        return name;
    }

    public static void setSelectedName(String name) {
        Base.preferences.put("replicatorg.generator.name", name);
    }

    public static ToolpathGenerator createSelectedGenerator() {
        String name = ToolpathGeneratorFactory.getSelectedName();
        Vector<ToolpathGeneratorDescriptor> list = ToolpathGeneratorFactory.getGeneratorList();
        ToolpathGenerator tg = null;
        for (ToolpathGeneratorDescriptor tgd : list) {
            if (!name.equals(tgd.name)) continue;
            tg = tgd.instantiate();
            break;
        }
        return tg;
    }

    public static class ToolpathGeneratorDescriptor {
        public String name;
        public String description;
        public Class<?> tpClass;

        public ToolpathGeneratorDescriptor(String name, String description, Class<?> tpClass) {
            this.name = name;
            this.description = description;
            this.tpClass = tpClass;
        }

        public ToolpathGenerator instantiate() {
            try {
                return (ToolpathGenerator)this.tpClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

