/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.User;
import twitter4j.http.Response;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetweetDetails
extends TwitterResponse
implements Serializable {
    private long retweetId;
    private Date retweetedAt;
    private User retweetingUser;
    static final long serialVersionUID = 1957982268696560598L;

    RetweetDetails(Response res, Twitter twitter) throws TwitterException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.init(res, elem, twitter);
    }

    RetweetDetails(Response res, Element elem, Twitter twitter) throws TwitterException {
        super(res);
        this.init(res, elem, twitter);
    }

    private void init(Response res, Element elem, Twitter twitter) throws TwitterException {
        RetweetDetails.ensureRootNodeNameIs("retweet_details", elem);
        this.retweetId = RetweetDetails.getChildLong("retweet_id", elem);
        this.retweetedAt = RetweetDetails.getChildDate("retweeted_at", elem);
        this.retweetingUser = new User(res, (Element)elem.getElementsByTagName("retweeting_user").item(0), twitter);
    }

    public long getRetweetId() {
        return this.retweetId;
    }

    public Date getRetweetedAt() {
        return this.retweetedAt;
    }

    public User getRetweetingUser() {
        return this.retweetingUser;
    }

    static List<RetweetDetails> createRetweetDetails(Response res, Twitter twitter) throws TwitterException {
        Document doc = res.asDocument();
        if (RetweetDetails.isRootNodeNilClasses(doc)) {
            return new ArrayList<RetweetDetails>(0);
        }
        try {
            RetweetDetails.ensureRootNodeNameIs("retweets", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("retweet_details");
            int size = list.getLength();
            ArrayList<RetweetDetails> statuses = new ArrayList<RetweetDetails>(size);
            for (int i = 0; i < size; ++i) {
                Element status = (Element)list.item(i);
                statuses.add(new RetweetDetails(res, status, twitter));
            }
            return statuses;
        }
        catch (TwitterException te) {
            RetweetDetails.ensureRootNodeNameIs("nil-classes", doc);
            return new ArrayList<RetweetDetails>(0);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetweetDetails)) {
            return false;
        }
        RetweetDetails that = (RetweetDetails)o;
        return this.retweetId == that.retweetId;
    }

    public int hashCode() {
        int result = (int)(this.retweetId ^ this.retweetId >>> 32);
        result = 31 * result + this.retweetedAt.hashCode();
        result = 31 * result + this.retweetingUser.hashCode();
        return result;
    }

    public String toString() {
        return new StringBuffer().append("RetweetDetails{retweetId=").append(this.retweetId).append(", retweetedAt=").append(this.retweetedAt).append(", retweetingUser=").append(this.retweetingUser).append('}').toString();
    }
}

