/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.Config;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.jnl.JARUpdater;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.net.URL;

public class JARDesc
implements ResourceType {
    private URL _location;
    private String _version;
    private int _size;
    private boolean _isNativeLib;
    private boolean _isLazyDownload;
    private boolean _isMainFile;
    private String _part;
    private ResourcesDesc _parent;
    private JARUpdater _updater = null;
    public static final String PROP_NAME_PACK_ENABLED = "jnlp.packEnabled";
    public static final String PROP_NAME_VERSION_ENABLED = "jnlp.versionEnabled";
    private static final boolean isConfigValid = Config.isConfigValid();
    private static final boolean sysPackEnabled = Config.isJavaVersionAtLeast15() ? Boolean.getBoolean("jnlp.packEnabled") : false;
    private static final boolean sysVersionEnabled = Boolean.getBoolean("jnlp.versionEnabled");

    public JARDesc(URL uRL, String string, boolean bl, boolean bl2, boolean bl3, String string2, int n, ResourcesDesc resourcesDesc) {
        this._location = uRL;
        this._version = string;
        this._isLazyDownload = bl && !this._isMainFile;
        this._isNativeLib = bl3;
        this._isMainFile = bl2;
        this._part = string2;
        this._size = n;
        this._parent = resourcesDesc;
    }

    public boolean isPack200Enabled() {
        if (sysPackEnabled) {
            return true;
        }
        if (this._parent != null) {
            return this._parent.isPack200Enabled();
        }
        return false;
    }

    public boolean isVersionEnabled() {
        if (sysVersionEnabled) {
            return true;
        }
        if (this._parent != null) {
            return this._parent.isVersionEnabled();
        }
        return false;
    }

    public boolean isNativeLib() {
        return this._isNativeLib;
    }

    public boolean isJavaFile() {
        return !this._isNativeLib;
    }

    public URL getLocation() {
        return this._location;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isLazyDownload() {
        return this._isLazyDownload;
    }

    public void setLazyDownload(boolean bl) {
        this._isLazyDownload = bl;
    }

    public boolean isMainJarFile() {
        return this._isMainFile;
    }

    public String getPartName() {
        return this._part;
    }

    public int getSize() {
        return this._size;
    }

    public ResourcesDesc getParent() {
        return this._parent;
    }

    public void visit(ResourceVisitor resourceVisitor) {
        resourceVisitor.visitJARDesc(this);
    }

    public synchronized JARUpdater getUpdater() {
        if (this._updater == null) {
            this._updater = new JARUpdater(this);
        }
        return this._updater;
    }

    public XMLNode asXML() {
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        xMLAttributeBuilder.add("href", this._location);
        xMLAttributeBuilder.add("version", this._version);
        xMLAttributeBuilder.add("part", this._part);
        xMLAttributeBuilder.add("download", this.isLazyDownload() ? "lazy" : "eager");
        xMLAttributeBuilder.add("main", this.isMainJarFile() ? "true" : "false");
        String string = this._isNativeLib ? "nativelib" : "jar";
        return new XMLNode(string, xMLAttributeBuilder.getAttributeList());
    }

    public String toString() {
        return "JARDesc[" + this._location + ":" + this._version + "]";
    }

    public boolean equals(Object object) {
        if (!(object instanceof JARDesc)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        JARDesc jARDesc = (JARDesc)object;
        if (this.getVersion() != null) {
            return this.getVersion().equals(jARDesc.getVersion()) && this.getLocation().toString().equals(jARDesc.getLocation().toString());
        }
        return jARDesc.getVersion() == null && this.getLocation().toString().equals(jARDesc.getLocation().toString());
    }

    public int hashCode() {
        int n = 0;
        if (this.getVersion() != null) {
            n = this.getVersion().hashCode();
        }
        if (this.getLocation() != null) {
            n ^= this.getLocation().toString().hashCode();
        }
        return n;
    }
}

