/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ProgressMonitorInputStream;
import org.j3d.loaders.stl.STLParser;

class STLASCIIParser
extends STLParser {
    private BufferedReader itsReader;
    private StreamTokenizer itsTokenizer;

    @Override
    public void close() throws IOException {
        if (this.itsReader != null) {
            this.itsReader.close();
        }
    }

    @Override
    public boolean getNextFacet(double[] normal, double[][] vertices) throws IOException {
        int type = this.itsTokenizer.nextToken();
        if (type == -1) {
            this.close();
            throw new IOException("Unexpected EOF");
        }
        if (type == -3) {
            if (this.itsTokenizer.sval.indexOf("s") >= 0) {
                this.skipObjectName(this.itsTokenizer);
                type = this.itsTokenizer.nextToken();
                if (type == -1) {
                    this.close();
                    return false;
                }
                this.skipObjectName(this.itsTokenizer);
            } else {
                this.itsTokenizer.pushBack();
            }
            this.readVector(this.itsTokenizer, normal);
            int i = 0;
            while (i < 3) {
                this.readVector(this.itsTokenizer, vertices[i]);
                ++i;
            }
            return true;
        }
        this.close();
        throw new IOException("Unexpected data found");
    }

    @Override
    public boolean parse(URL url, Component parentComponent) throws InterruptedIOException, IOException {
        InputStream stream = null;
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            if (stream != null) {
                stream.close();
            }
            throw e;
        }
        stream = new ProgressMonitorInputStream(parentComponent, "analyzing " + url.toString(), stream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        boolean isAscii = false;
        try {
            isAscii = this.parse(reader);
        }
        finally {
            reader.close();
        }
        if (isAscii) {
            try {
                stream = url.openStream();
            }
            catch (IOException e) {
                stream.close();
                throw e;
            }
            stream = new ProgressMonitorInputStream(parentComponent, "parsing " + url.toString(), stream);
            reader = new BufferedReader(new InputStreamReader(stream));
            try {
                this.configureTokenizer(reader);
            }
            catch (IOException e) {
                reader.close();
                throw e;
            }
            this.itsReader = reader;
        }
        return isAscii;
    }

    @Override
    public boolean parse(URL url) throws IOException {
        boolean isAscii;
        BufferedReader reader;
        InputStream stream;
        block13: {
            stream = null;
            try {
                stream = url.openStream();
            }
            catch (IOException e) {
                if (stream != null) {
                    stream.close();
                }
                throw e;
            }
            reader = new BufferedReader(new InputStreamReader(stream));
            isAscii = false;
            try {
                try {
                    isAscii = this.parse(reader);
                }
                catch (InterruptedIOException e) {
                    e.printStackTrace();
                    reader.close();
                    break block13;
                }
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
        }
        if (isAscii) {
            try {
                stream = url.openStream();
            }
            catch (IOException e) {
                stream.close();
                throw e;
            }
            reader = new BufferedReader(new InputStreamReader(stream));
            try {
                this.configureTokenizer(reader);
            }
            catch (IOException e) {
                reader.close();
                throw e;
            }
            this.itsReader = reader;
        }
        return isAscii;
    }

    /*
     * Unable to fully structure code
     */
    private boolean parse(BufferedReader reader) throws InterruptedIOException, IOException {
        numOfObjects = 0;
        numOfFacets = 0;
        facetsPerObject = new ArrayList<Integer>(10);
        names = new ArrayList<String>(10);
        isAscii = true;
        line = reader.readLine();
        if (line.indexOf("solid") >= 0) ** GOTO lbl34
        return false;
lbl-1000:
        // 1 sources

        {
            if (line.indexOf("facet") >= 0) {
                ++numOfFacets;
                i = 0;
                while (i < 6) {
                    reader.readLine();
                    ++i;
                }
            } else if (line.indexOf("endsolid") >= 0) {
                facetsPerObject.add(new Integer(numOfFacets));
                numOfFacets = 0;
                ++numOfObjects;
            } else if (line.indexOf("solid") >= 0) {
                if (line.length() > 6) {
                    names.add(line.substring(6));
                } else {
                    names.add("default");
                }
            } else {
                return false;
            }
            line = reader.readLine();
lbl34:
            // 2 sources

            ** while (line != null)
        }
lbl35:
        // 1 sources

        this.itsNumOfObjects = numOfObjects;
        this.itsNumOfFacets = new int[numOfObjects];
        this.itsNames = new String[numOfObjects];
        i = 0;
        while (i < numOfObjects) {
            num = (Integer)facetsPerObject.get(i);
            this.itsNumOfFacets[i] = num;
            this.itsNames[i] = (String)names.get(i);
            ++i;
        }
        return true;
    }

    private void configureTokenizer(BufferedReader reader) throws IOException {
        reader.readLine();
        this.itsTokenizer = new StreamTokenizer(reader);
        this.itsTokenizer.resetSyntax();
        this.itsTokenizer.wordChars(48, 57);
        this.itsTokenizer.wordChars(69, 69);
        this.itsTokenizer.wordChars(43, 43);
        this.itsTokenizer.wordChars(45, 45);
        this.itsTokenizer.wordChars(46, 46);
        this.itsTokenizer.wordChars(115, 115);
        this.itsTokenizer.whitespaceChars(0, 32);
        this.itsTokenizer.whitespaceChars(97, 114);
        this.itsTokenizer.whitespaceChars(116, 122);
    }

    private void readVector(StreamTokenizer tokenizer, double[] vector) throws IOException {
        int i = 0;
        while (i < 3) {
            int type = tokenizer.nextToken();
            if (type == -3) {
                try {
                    vector[i] = Double.parseDouble(tokenizer.sval);
                }
                catch (NumberFormatException e) {
                    throw new IOException("Unexpected data found");
                }
            } else {
                if (type == -1) {
                    throw new IOException("Unexpected EOF");
                }
                throw new IOException("Unexpected data found.");
            }
            ++i;
        }
    }

    private void skipObjectName(StreamTokenizer tokenizer) throws IOException {
        this.itsTokenizer.eolIsSignificant(true);
        int type = 0;
        while (type != 10) {
            type = this.itsTokenizer.nextToken();
        }
        this.itsTokenizer.eolIsSignificant(false);
    }
}

