/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import replicatorg.drivers.OnboardParameters;
import replicatorg.drivers.Version;
import replicatorg.drivers.gen3.Sanguino3GDriver;

public class ExtruderOnboardParameters
extends JFrame {
    private static final long serialVersionUID = 6353987389397209816L;
    private OnboardParameters target;
    final int FIELD_WIDTH = 10;
    Vector<Commitable> commitList = new Vector();

    private boolean commit() {
        for (Commitable c : this.commitList) {
            if (c.isCommitable()) continue;
            return false;
        }
        for (Commitable c : this.commitList) {
            c.commit();
        }
        JOptionPane.showMessageDialog(this, "Changes will not take effect until the extruder board is reset.  You can \ndo this by turning your machine off and then on, or by disconnecting and \nreconnecting the extruder cable.  Make sure you don't still have a USB2TTL \ncable attached to the extruder controller, as the cable will keep the board \nfrom resetting.", "Extruder controller reminder", 1);
        return true;
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        JButton commitButton = new JButton("Commit Changes");
        panel.add(commitButton);
        commitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ExtruderOnboardParameters.this.commit()) {
                    ExtruderOnboardParameters.this.dispose();
                }
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExtruderOnboardParameters.this.dispose();
            }
        });
        panel.add(cancelButton);
        return panel;
    }

    public ExtruderOnboardParameters(OnboardParameters target) {
        super("Update onboard extruder options");
        this.target = target;
        Version v = new Version(0, 0);
        if (target instanceof Sanguino3GDriver) {
            v = ((Sanguino3GDriver)target).getToolVersion();
        }
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        ThermistorTablePanel ttp = new ThermistorTablePanel(0, "Extruder thermistor");
        panel.add(ttp);
        this.commitList.add(ttp);
        ttp = new ThermistorTablePanel(1, "Heated build platform thermistor");
        panel.add((Component)ttp, "wrap");
        this.commitList.add(ttp);
        if (!v.atLeast(new Version(2, 5))) {
            BackoffPanel backoffPanel = new BackoffPanel();
            panel.add((Component)backoffPanel, "span 2,growx,wrap");
            this.commitList.add(backoffPanel);
        }
        if (v.atLeast(new Version(2, 5))) {
            ExtraFeaturesPanel efp = new ExtraFeaturesPanel();
            panel.add((Component)efp, "span 2,growx,wrap");
            this.commitList.add(efp);
        }
        PIDPanel pidPanel = new PIDPanel(0, "Extruder");
        panel.add((Component)pidPanel, "growx");
        this.commitList.add(pidPanel);
        if (v.atLeast(new Version(2, 4))) {
            PIDPanel pp = new PIDPanel(1, "Heated build platform");
            panel.add((Component)pp, "growx,wrap");
            this.commitList.add(pp);
        }
        if (v.atLeast(new Version(2, 9))) {
            RegulatedCoolingFan rcf = new RegulatedCoolingFan();
            panel.add((Component)rcf, "span 2,growx,wrap");
            this.commitList.add(rcf);
        }
        panel.add((Component)this.makeButtonPanel(), "span 2,newline");
        this.add(panel);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2);
    }

    private class BackoffPanel
    extends JPanel
    implements Commitable {
        private static final long serialVersionUID = 6593800743174557032L;
        private JTextField stopMsField = new JTextField();
        private JTextField reverseMsField = new JTextField();
        private JTextField forwardMsField = new JTextField();
        private JTextField triggerMsField = new JTextField();

        BackoffPanel() {
            this.setLayout((LayoutManager)new MigLayout());
            this.setBorder(BorderFactory.createTitledBorder("Reversal parameters"));
            this.stopMsField.setColumns(10);
            this.reverseMsField.setColumns(10);
            this.forwardMsField.setColumns(10);
            this.triggerMsField.setColumns(10);
            this.add(new JLabel("Time to pause (ms)"));
            this.add((Component)this.stopMsField, "wrap");
            this.add(new JLabel("Time to reverse (ms)"));
            this.add((Component)this.reverseMsField, "wrap");
            this.add(new JLabel("Time to advance (ms)"));
            this.add((Component)this.forwardMsField, "wrap");
            this.add(new JLabel("Min. extrusion time before reversal (ms)"));
            this.add((Component)this.triggerMsField, "wrap");
            OnboardParameters.BackoffParameters bp = ExtruderOnboardParameters.this.target.getBackoffParameters();
            this.stopMsField.setText(Integer.toString(bp.stopMs));
            this.reverseMsField.setText(Integer.toString(bp.reverseMs));
            this.forwardMsField.setText(Integer.toString(bp.forwardMs));
            this.triggerMsField.setText(Integer.toString(bp.triggerMs));
        }

        @Override
        public void commit() {
            OnboardParameters.BackoffParameters bp = new OnboardParameters.BackoffParameters();
            bp.forwardMs = Integer.parseInt(this.forwardMsField.getText());
            bp.reverseMs = Integer.parseInt(this.reverseMsField.getText());
            bp.stopMs = Integer.parseInt(this.stopMsField.getText());
            bp.triggerMs = Integer.parseInt(this.triggerMsField.getText());
            ExtruderOnboardParameters.this.target.setBackoffParameters(bp);
        }

        @Override
        public boolean isCommitable() {
            return true;
        }
    }

    static interface Commitable {
        public void commit();

        public boolean isCommitable();
    }

    private class ExtraFeaturesPanel
    extends JPanel
    implements Commitable {
        private JCheckBox swapMotors;
        private JComboBox extCh;
        private JComboBox hbpCh;
        private JComboBox abpCh;
        private OnboardParameters.ExtraFeatures ef;

        ExtraFeaturesPanel() {
            this.setLayout((LayoutManager)new MigLayout());
            this.ef = ExtruderOnboardParameters.this.target.getExtraFeatures();
            this.swapMotors = new JCheckBox("Use 2A/2B to drive DC motor instead of 1A/1B", this.ef.swapMotorController);
            this.add((Component)this.swapMotors, "span 3,growx,wrap");
            Vector<String> choices = new Vector<String>();
            choices.add("Channel A");
            choices.add("Channel B");
            choices.add("Channel C");
            this.extCh = new JComboBox(choices);
            this.extCh.setSelectedIndex(this.ef.heaterChannel);
            this.add(new JLabel("Extruder heater uses:"));
            this.add(this.extCh);
            this.add((Component)new JLabel("(default ch. B)"), "wrap");
            this.hbpCh = new JComboBox(choices);
            this.hbpCh.setSelectedIndex(this.ef.hbpChannel);
            this.add(new JLabel("Platform heater uses:"));
            this.add(this.hbpCh);
            this.add((Component)new JLabel("(default ch. A)"), "wrap");
            this.abpCh = new JComboBox(choices);
            this.abpCh.setSelectedIndex(this.ef.abpChannel);
            this.add(new JLabel("ABP motor uses:"));
            this.add(this.abpCh);
            this.add((Component)new JLabel("(default ch. C)"), "wrap");
        }

        @Override
        public void commit() {
            this.ef.swapMotorController = this.swapMotors.isSelected();
            this.ef.heaterChannel = this.extCh.getSelectedIndex();
            this.ef.hbpChannel = this.hbpCh.getSelectedIndex();
            this.ef.abpChannel = this.abpCh.getSelectedIndex();
            ExtruderOnboardParameters.this.target.setExtraFeatures(this.ef);
        }

        @Override
        public boolean isCommitable() {
            int a = this.extCh.getSelectedIndex();
            int b = this.hbpCh.getSelectedIndex();
            int c = this.abpCh.getSelectedIndex();
            if (a == b || b == c || a == c) {
                JOptionPane.showMessageDialog(this, "Two or more features are using the same mosfet channel!", "Channel conflict", 0);
                return false;
            }
            return true;
        }
    }

    private class PIDPanel
    extends JPanel
    implements Commitable {
        private JTextField pField = new JTextField();
        private JTextField iField = new JTextField();
        private JTextField dField = new JTextField();
        private int which;

        PIDPanel(int which, String name) {
            this.which = which;
            this.setLayout((LayoutManager)new MigLayout());
            this.setBorder(BorderFactory.createTitledBorder(String.valueOf(name) + " PID parameters"));
            this.pField.setColumns(10);
            this.iField.setColumns(10);
            this.dField.setColumns(10);
            this.add(new JLabel("P parameter"));
            this.add((Component)this.pField, "wrap");
            this.add(new JLabel("I parameter"));
            this.add((Component)this.iField, "wrap");
            this.add(new JLabel("D parameter"));
            this.add((Component)this.dField, "wrap");
            OnboardParameters.PIDParameters pp = ExtruderOnboardParameters.this.target.getPIDParameters(which);
            this.pField.setText(Float.toString(pp.p));
            this.iField.setText(Float.toString(pp.i));
            this.dField.setText(Float.toString(pp.d));
        }

        @Override
        public void commit() {
            OnboardParameters.PIDParameters pp = new OnboardParameters.PIDParameters();
            pp.p = Float.parseFloat(this.pField.getText());
            pp.i = Float.parseFloat(this.iField.getText());
            pp.d = Float.parseFloat(this.dField.getText());
            ExtruderOnboardParameters.this.target.setPIDParameters(this.which, pp);
        }

        @Override
        public boolean isCommitable() {
            return true;
        }
    }

    class RegulatedCoolingFan
    extends JPanel
    implements Commitable {
        private static final long serialVersionUID = 7765098486598830410L;
        private JCheckBox coolingFanEnabled;
        private JTextField coolingFanSetpoint;

        RegulatedCoolingFan() {
            super((LayoutManager)new MigLayout());
            this.coolingFanSetpoint = new JTextField();
            this.coolingFanEnabled = new JCheckBox("Enable regulated cooling fan (stepper extruders only)", ExtruderOnboardParameters.this.target.getCoolingFanEnabled());
            this.add((Component)this.coolingFanEnabled, "growx,wrap");
            this.coolingFanSetpoint.setColumns(10);
            this.coolingFanSetpoint.setText(Integer.toString(ExtruderOnboardParameters.this.target.getCoolingFanSetpoint()));
            this.add(new JLabel("Setpoint (C)"));
            this.add((Component)this.coolingFanSetpoint, "wrap");
        }

        @Override
        public void commit() {
            boolean enabled = this.coolingFanEnabled.isSelected();
            int setpoint = Integer.parseInt(this.coolingFanSetpoint.getText());
            ExtruderOnboardParameters.this.target.setCoolingFanParameters(enabled, setpoint);
        }

        @Override
        public boolean isCommitable() {
            return true;
        }
    }

    class ThermistorTablePanel
    extends JPanel
    implements Commitable {
        private static final long serialVersionUID = 7765098486598830410L;
        private JTextField betaField;
        private JTextField r0Field;
        private JTextField t0Field;
        private int which;

        ThermistorTablePanel(int which, String titleText) {
            super((LayoutManager)new MigLayout());
            this.betaField = new JTextField();
            this.r0Field = new JTextField();
            this.t0Field = new JTextField();
            this.which = which;
            this.setBorder(BorderFactory.createTitledBorder(titleText));
            this.betaField.setColumns(10);
            this.r0Field.setColumns(10);
            this.t0Field.setColumns(10);
            double beta = ExtruderOnboardParameters.this.target.getBeta(which);
            if (beta == -1.0) {
                beta = 4066.0;
            }
            this.betaField.setText(Integer.toString((int)beta));
            this.add(new JLabel("Beta"));
            this.add((Component)this.betaField, "wrap");
            double r0 = ExtruderOnboardParameters.this.target.getR0(which);
            if (r0 == -1.0) {
                r0 = 100000.0;
            }
            this.r0Field.setText(Integer.toString((int)r0));
            this.add(new JLabel("Thermistor Resistance"));
            this.add((Component)this.r0Field, "wrap");
            double t0 = ExtruderOnboardParameters.this.target.getT0(which);
            if (t0 == -1.0) {
                t0 = 25.0;
            }
            this.t0Field.setText(Integer.toString((int)t0));
            this.add(new JLabel("Base Temperature"));
            this.add((Component)this.t0Field, "wrap");
        }

        @Override
        public void commit() {
            int beta = Integer.parseInt(this.betaField.getText());
            int r0 = Integer.parseInt(this.r0Field.getText());
            int t0 = Integer.parseInt(this.t0Field.getText());
            ExtruderOnboardParameters.this.target.createThermistorTable(this.which, r0, t0, beta);
        }

        @Override
        public boolean isCommitable() {
            return true;
        }
    }
}

