/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.EnumSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import replicatorg.drivers.Driver;
import replicatorg.drivers.OnboardParameters;
import replicatorg.machine.model.AxisId;

public class MachineOnboardParameters
extends JFrame {
    private static final long serialVersionUID = 7876192459063774731L;
    private final OnboardParameters target;
    private final Driver driver;
    private JTextField machineNameField = new JTextField();
    private JCheckBox xAxisInvertBox = new JCheckBox();
    private JCheckBox yAxisInvertBox = new JCheckBox();
    private JCheckBox zAxisInvertBox = new JCheckBox();
    private JCheckBox aAxisInvertBox = new JCheckBox();
    private JCheckBox bAxisInvertBox = new JCheckBox();
    private JButton resetToFactoryButton = new JButton("Reset motherboard to factory settings");
    private static final String[] endstopInversionChoices = new String[]{"No endstops installed", "Inverted (Default; H21LOB-based enstops)", "Non-inverted (H21LOI-based endstops)"};
    private JComboBox endstopInversionSelection = new JComboBox<String>(endstopInversionChoices);
    private static final String[] estopChoices = new String[]{"No emergency stop installed", "Active high emergency stop (safety cutoff kit)", "Active low emergency stop (custom solution)"};
    private JComboBox estopSelection = new JComboBox<String>(estopChoices);
    private static final int MAX_NAME_LENGTH = 16;
    private JTextField xAxisHomeOffsetField = new JTextField();
    private JTextField yAxisHomeOffsetField = new JTextField();
    private JTextField zAxisHomeOffsetField = new JTextField();
    private JTextField aAxisHomeOffsetField = new JTextField();
    private JTextField bAxisHomeOffsetField = new JTextField();

    private void resetDialog() {
        int confirm = JOptionPane.showConfirmDialog(this, "<html>Before these changes can take effect, you'll need to reset your <br/>motherboard.  If you choose not to reset the board now, some old settings <br/>will remain in effect until you manually reset.<br/><br/>Reset the motherboard now?</html>", "Reset board?", 0, 2);
        if (confirm == 0) {
            this.driver.reset();
        }
    }

    private void commit() {
        this.target.setMachineName(this.machineNameField.getText());
        EnumSet<AxisId> axesInverted = EnumSet.noneOf(AxisId.class);
        if (this.xAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.X);
        }
        if (this.yAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.Y);
        }
        if (this.zAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.Z);
        }
        if (this.aAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.A);
        }
        if (this.bAxisInvertBox.isSelected()) {
            axesInverted.add(AxisId.B);
        }
        this.target.setInvertedParameters(axesInverted);
        int idx = this.endstopInversionSelection.getSelectedIndex();
        OnboardParameters.EndstopType endstops = OnboardParameters.EndstopType.values()[idx];
        this.target.setInvertedEndstops(endstops);
        idx = this.estopSelection.getSelectedIndex();
        OnboardParameters.EstopType estop = OnboardParameters.EstopType.estopTypeForValue((byte)idx);
        this.target.setEstopConfig(estop);
        this.target.setAxisHomeOffset(0, Double.parseDouble(this.xAxisHomeOffsetField.getText()));
        this.target.setAxisHomeOffset(1, Double.parseDouble(this.yAxisHomeOffsetField.getText()));
        this.target.setAxisHomeOffset(2, Double.parseDouble(this.zAxisHomeOffsetField.getText()));
        this.target.setAxisHomeOffset(3, Double.parseDouble(this.aAxisHomeOffsetField.getText()));
        this.target.setAxisHomeOffset(4, Double.parseDouble(this.bAxisHomeOffsetField.getText()));
        this.resetDialog();
    }

    private void resetToFactory() {
        this.target.resetToFactory();
        this.resetDialog();
        this.loadParameters();
    }

    double roundDouble(double number) {
        DecimalFormat twoDForm = new DecimalFormat("#.###");
        return Double.valueOf(twoDForm.format(number));
    }

    private void loadParameters() {
        this.machineNameField.setText(this.target.getMachineName());
        EnumSet<AxisId> invertedAxes = this.target.getInvertedParameters();
        this.xAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.X));
        this.yAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.Y));
        this.zAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.Z));
        this.aAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.A));
        this.bAxisInvertBox.setSelected(invertedAxes.contains((Object)AxisId.B));
        OnboardParameters.EndstopType endstops = this.target.getInvertedEndstops();
        this.endstopInversionSelection.setSelectedIndex(endstops.ordinal());
        OnboardParameters.EstopType estop = this.target.getEstopConfig();
        this.estopSelection.setSelectedIndex(estop.ordinal());
        this.xAxisHomeOffsetField.setText(Double.toString(this.roundDouble(this.target.getAxisHomeOffset(0))));
        this.yAxisHomeOffsetField.setText(Double.toString(this.roundDouble(this.target.getAxisHomeOffset(1))));
        this.zAxisHomeOffsetField.setText(Double.toString(this.roundDouble(this.target.getAxisHomeOffset(2))));
        this.aAxisHomeOffsetField.setText(Double.toString(this.roundDouble(this.target.getAxisHomeOffset(3))));
        this.bAxisHomeOffsetField.setText(Double.toString(this.roundDouble(this.target.getAxisHomeOffset(4))));
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        JButton commitButton = new JButton("Commit Changes");
        panel.add(commitButton);
        commitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MachineOnboardParameters.this.commit();
                MachineOnboardParameters.this.dispose();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MachineOnboardParameters.this.dispose();
            }
        });
        panel.add(cancelButton);
        return panel;
    }

    public MachineOnboardParameters(OnboardParameters target, Driver driver) {
        super("Update onboard machine options");
        this.target = target;
        this.driver = driver;
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        panel.add(new JLabel("Machine Name (max. " + Integer.toString(16) + " chars)"));
        this.machineNameField.setColumns(16);
        panel.add((Component)this.machineNameField, "wrap");
        panel.add(new JLabel("Invert X axis"));
        panel.add((Component)this.xAxisInvertBox, "wrap");
        panel.add(new JLabel("Invert Y axis"));
        panel.add((Component)this.yAxisInvertBox, "wrap");
        panel.add(new JLabel("Invert Z axis"));
        panel.add((Component)this.zAxisInvertBox, "wrap");
        panel.add(new JLabel("Invert A axis"));
        panel.add((Component)this.aAxisInvertBox, "wrap");
        panel.add(new JLabel("Invert B axis"));
        panel.add((Component)this.bAxisInvertBox, "wrap");
        panel.add(new JLabel("Invert endstops"));
        panel.add((Component)this.endstopInversionSelection, "wrap");
        panel.add(new JLabel("Emergency stop"));
        panel.add((Component)this.estopSelection, "wrap");
        this.xAxisHomeOffsetField.setColumns(10);
        this.yAxisHomeOffsetField.setColumns(10);
        this.zAxisHomeOffsetField.setColumns(10);
        this.aAxisHomeOffsetField.setColumns(10);
        this.bAxisHomeOffsetField.setColumns(10);
        panel.add(new JLabel("X home offset (mm)"));
        panel.add((Component)this.xAxisHomeOffsetField, "wrap");
        panel.add(new JLabel("Y home offset (mm)"));
        panel.add((Component)this.yAxisHomeOffsetField, "wrap");
        panel.add(new JLabel("Z home offset (mm)"));
        panel.add((Component)this.zAxisHomeOffsetField, "wrap");
        panel.add(new JLabel("A home offset (mm)"));
        panel.add((Component)this.aAxisHomeOffsetField, "wrap");
        panel.add(new JLabel("B home offset (mm)"));
        panel.add((Component)this.bAxisHomeOffsetField, "wrap");
        this.resetToFactoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MachineOnboardParameters.this.resetToFactory();
                MachineOnboardParameters.this.loadParameters();
            }
        });
        panel.add((Component)this.resetToFactoryButton, "wrap");
        panel.add(this.makeButtonPanel());
        this.add(panel);
        this.pack();
        this.loadParameters();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2);
    }
}

