/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.drivers.commands.QueuePoint;
import replicatorg.drivers.commands.SetCurrentPosition;
import replicatorg.drivers.commands.SetFeedrate;
import replicatorg.machine.MachineInterface;
import replicatorg.machine.model.AxisId;
import replicatorg.util.Point5d;

public class JogPanel
extends JPanel
implements ActionListener,
MouseListener {
    private final String JOGMODE_PREF_NAME = "controlpanel.jogmode";
    protected boolean continuousJogMode = false;
    protected double jogRate;
    protected Pattern jogPattern;
    protected String[] jogStrings = new String[]{"0.01mm", "0.05mm", "0.1mm", "0.5mm", "1mm", "5mm", "10mm", "20mm", "50mm", "Continuous Jog"};
    protected final Point5d feedrate;
    protected EnumMap<AxisId, JTextField> positionFields = new EnumMap(AxisId.class);
    protected MachineInterface machine;
    DecimalFormat positionFormatter = new DecimalFormat("###.##");
    Pattern jogActionParser = Pattern.compile("([XYZAB])([\\+\\-])");
    Pattern centerActionParser = Pattern.compile("Center ([XYZAB])");

    protected JButton createJogButton(String root, String tooltip) {
        JogButton b = new JogButton(root, tooltip);
        b.addActionListener(this);
        b.addMouseListener(this);
        return b;
    }

    protected JButton createJogButton(String root, String tooltip, String action) {
        JButton button = this.createJogButton(root, tooltip);
        button.setActionCommand(action);
        return button;
    }

    protected JTextField createDisplayField() {
        JTextField tf = new JTextField();
        tf.setEnabled(false);
        tf.setDisabledTextColor(Color.BLACK);
        return tf;
    }

    private void setJogMode(String mode) {
        if ("Continuous Jog".equals(mode)) {
            if (this.machine.getDriver().hasSoftStop()) {
                this.continuousJogMode = true;
                this.jogRate = 0.0;
            }
        } else {
            if (this.continuousJogMode) {
                this.machine.stopMotion();
            }
            this.continuousJogMode = false;
            Matcher jogMatcher = this.jogPattern.matcher(mode);
            if (jogMatcher.find()) {
                this.jogRate = Double.parseDouble(jogMatcher.group(1));
            }
        }
        if (mode != null && mode.length() > 0) {
            Base.preferences.put("controlpanel.jogmode", mode);
        }
    }

    private JPanel buildPositionPanel() {
        JPanel positionPanel = new JPanel((LayoutManager)new MigLayout("flowy,fillx"));
        positionPanel.add((Component)new JLabel("Jog Mode"), "growx");
        JComboBox<String> jogList = new JComboBox<String>(this.jogStrings);
        jogList.setSelectedItem(Base.preferences.get("controlpanel.jogmode", "1mm"));
        jogList.setActionCommand("jog size");
        jogList.addActionListener(this);
        this.setJogMode((String)jogList.getSelectedItem());
        positionPanel.add(jogList, "growx");
        for (AxisId axis : this.machine.getModel().getAvailableAxes()) {
            JTextField f = this.createDisplayField();
            this.positionFields.put(axis, f);
            positionPanel.add((Component)new JLabel(axis.name()), "split 3,flowx");
            positionPanel.add((Component)f, "growx");
            JButton centerButton = new JButton("Center " + axis.name());
            centerButton.setToolTipText("Jog " + axis.name() + " axis to the origin");
            centerButton.setActionCommand("Center " + axis.name());
            centerButton.addActionListener(this);
            positionPanel.add(centerButton);
        }
        JButton zeroButton = new JButton("Make current position zero");
        zeroButton.setToolTipText("Mark Current Position as zero (0,0,0).  Will not move the toolhead.");
        zeroButton.setActionCommand("Zero");
        zeroButton.addActionListener(this);
        positionPanel.add((Component)zeroButton, "growx");
        return positionPanel;
    }

    private JPanel makeRotationPanel(AxisId axis) {
        JButton cwButton = this.createJogButton("jog/CW", "Jog " + axis.name() + " axis in clockwise direction", String.valueOf(axis.name()) + "+");
        JButton ccwButton = this.createJogButton("jog/CCW", "Jog " + axis.name() + " axis in counterclockwise direction", String.valueOf(axis.name()) + "-");
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        panel.add(new JLabel(axis.name()));
        panel.add((Component)cwButton, "split 2,flowy");
        panel.add(ccwButton);
        return panel;
    }

    public JogPanel(MachineInterface machine) {
        this.feedrate = new Point5d();
        this.machine = machine;
        Set<AxisId> axes = machine.getModel().getAvailableAxes();
        this.setLayout((LayoutManager)new MigLayout("gap 0, ins 0"));
        this.jogRate = 10.0;
        this.jogPattern = Pattern.compile("([.0-9]+)");
        if (!this.machine.getDriver().hasSoftStop()) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.jogStrings));
            list.removeAll(Arrays.asList("Continuous Jog"));
            this.jogStrings = list.toArray(this.jogStrings);
        }
        JButton xPlusButton = this.createJogButton("jog/X+", "Jog X axis in positive direction", "X+");
        JButton xMinusButton = this.createJogButton("jog/X-", "Jog X axis in negative direction", "X-");
        JButton yPlusButton = this.createJogButton("jog/Y+", "Jog Y axis in positive direction", "Y+");
        JButton yMinusButton = this.createJogButton("jog/Y-", "Jog Y axis in negative direction", "Y-");
        JButton panicButton = this.createJogButton("jog/panic", "Emergency stop", "Stop");
        JPanel jogButtonPanel = new JPanel((LayoutManager)new MigLayout("nogrid, ins 0"));
        JPanel xyPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[]2[]2[]", "[]2[]2[]"));
        xyPanel.add((Component)yPlusButton, "skip 1,wrap,growx,growy");
        xyPanel.add((Component)xMinusButton, "growx,growy");
        if (this.machine.getDriver().hasEmergencyStop()) {
            xyPanel.add((Component)panicButton, "growx,growy");
        } else {
            JButton dummyButton = this.createJogButton("jog/dummy", "");
            xyPanel.add((Component)dummyButton, "growx,growy");
        }
        xyPanel.add((Component)xPlusButton, "growx,growy,wrap");
        xyPanel.add((Component)yMinusButton, "skip 1,growx,growy,wrap");
        jogButtonPanel.add(xyPanel);
        if (axes.contains((Object)AxisId.Z)) {
            JButton zPlusButton = this.createJogButton("jog/Z+", "Jog Z axis in positive direction", "Z+");
            JButton zMinusButton = this.createJogButton("jog/Z-", "Jog Z axis in negative direction", "Z-");
            JPanel zPanel = new JPanel((LayoutManager)new MigLayout("flowy"));
            zPanel.add(zPlusButton);
            zPanel.add(zMinusButton);
            jogButtonPanel.add((Component)zPanel, "wrap");
        }
        if (axes.contains((Object)AxisId.A)) {
            jogButtonPanel.add(this.makeRotationPanel(AxisId.A));
        }
        if (axes.contains((Object)AxisId.B)) {
            jogButtonPanel.add(this.makeRotationPanel(AxisId.B));
        }
        JPanel feedratePanel = new JPanel((LayoutManager)new MigLayout());
        if (axes.contains((Object)AxisId.X) || axes.contains((Object)AxisId.Y)) {
            new FeedrateControl("XY Feedrate", AxisId.X, feedratePanel);
        }
        if (axes.contains((Object)AxisId.Z)) {
            new FeedrateControl("Z Feedrate", AxisId.Z, feedratePanel);
        }
        if (axes.contains((Object)AxisId.A)) {
            new FeedrateControl("A Feedrate", AxisId.A, feedratePanel);
        }
        if (axes.contains((Object)AxisId.B)) {
            new FeedrateControl("B Feedrate", AxisId.B, feedratePanel);
        }
        this.add(jogButtonPanel);
        this.add((Component)this.buildPositionPanel(), "growx,wrap");
        this.add((Component)feedratePanel, "growx,spanx");
        this.setBorder(BorderFactory.createTitledBorder("Jog Controls"));
    }

    public synchronized void updateStatus() {
        Point5d current = this.machine.getDriverQueryInterface().getCurrentPosition(false);
        for (AxisId axis : this.machine.getModel().getAvailableAxes()) {
            double v = current.axis(axis);
            this.positionFields.get((Object)axis).setText(this.positionFormatter.format(v));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Point5d current = this.machine.getDriverQueryInterface().getCurrentPosition(false);
        String s = e.getActionCommand();
        Matcher jogMatch = this.jogActionParser.matcher(s);
        Matcher centerMatch = this.centerActionParser.matcher(s);
        if (jogMatch.matches()) {
            if (!this.continuousJogMode) {
                AxisId axis = AxisId.valueOf(jogMatch.group(1));
                boolean positive = jogMatch.group(2).equals("+");
                current.setAxis(axis, current.axis(axis) + (positive ? this.jogRate : -this.jogRate));
                double f = this.feedrate.axis(axis);
                if (axis.equals((Object)AxisId.Y)) {
                    f = this.feedrate.axis(AxisId.X);
                }
                this.machine.runCommand(new SetFeedrate(f));
                this.machine.runCommand(new QueuePoint(current));
            }
        } else if (s.equals("Stop")) {
            this.machine.stopMotion();
        } else if (centerMatch.matches()) {
            AxisId axis = AxisId.valueOf(centerMatch.group(1));
            current.setAxis(axis, 0.0);
            double f = this.feedrate.axis(axis);
            if (axis.equals((Object)AxisId.Y)) {
                f = this.feedrate.axis(AxisId.X);
            }
            this.machine.runCommand(new SetFeedrate(f));
            this.machine.runCommand(new QueuePoint(current));
        } else if (s.equals("Zero")) {
            this.machine.runCommand(new SetCurrentPosition(new Point5d()));
        } else if (s.equals("jog size")) {
            JComboBox cb = (JComboBox)e.getSource();
            String jogText = (String)cb.getSelectedItem();
            this.setJogMode(jogText);
        } else {
            Base.logger.warning("Unknown Action Event: " + s);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.continuousJogMode) {
            Point5d current = this.machine.getDriverQueryInterface().getCurrentPosition(false);
            String s = ((JButton)e.getSource()).getActionCommand();
            Matcher jogMatch = this.jogActionParser.matcher(s);
            if (jogMatch.matches()) {
                AxisId axis = AxisId.valueOf(jogMatch.group(1));
                boolean positive = jogMatch.group(2).equals("+");
                current.setAxis(axis, current.axis(axis) + (double)(positive ? 1000 : -1000));
                double f = this.feedrate.axis(axis);
                if (axis.equals((Object)AxisId.Y)) {
                    f = this.feedrate.axis(AxisId.X);
                }
                this.machine.runCommand(new SetFeedrate(f));
                this.machine.runCommand(new QueuePoint(current));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        if (this.continuousJogMode) {
            this.machine.stopMotion();
        }
    }

    private class FeedrateControl
    implements ActionListener,
    FocusListener,
    ChangeListener {
        final JSlider slider;
        final AxisId axis;
        final JTextField field;

        private FeedrateControl(String display, AxisId axis, JPanel parent) {
            this.axis = axis;
            this.slider = new JSlider(0);
            this.field = new JTextField();
            parent.add(new JLabel(display));
            int maxFeedrate = (int)JogPanel.this.machine.getModel().getMaximumFeedrates().axis(axis);
            int currentFeedrate = Math.min(maxFeedrate, Base.preferences.getInt(this.getPrefName(), 480));
            JogPanel.this.feedrate.setAxis(axis, currentFeedrate);
            this.slider.setMinimum(1);
            this.slider.setMaximum(maxFeedrate);
            this.slider.setValue(currentFeedrate);
            this.slider.addChangeListener(this);
            parent.add((Component)this.slider, "growx");
            this.field.setMinimumSize(new Dimension(75, 22));
            this.field.setEnabled(true);
            this.field.setText(Integer.toString(currentFeedrate));
            this.field.addFocusListener(this);
            this.field.addActionListener(this);
            parent.add((Component)this.field, "growx");
            parent.add((Component)new JLabel("mm/min."), "wrap");
        }

        String getPrefName() {
            return "controlpanel.feedrate." + this.axis.name().toLowerCase();
        }

        void updateFromField() {
            int val = Integer.parseInt(this.field.getText());
            JogPanel.this.feedrate.setAxis(this.axis, val);
            Base.preferences.putInt(this.getPrefName(), val);
            this.slider.setValue(val);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateFromField();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.updateFromField();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int val = this.slider.getValue();
            JogPanel.this.feedrate.setAxis(this.axis, val);
            Base.preferences.putInt(this.getPrefName(), val);
            this.field.setText(Integer.toString(val));
        }
    }

    public class JogButton
    extends JButton {
        public JogButton(String root, String tooltip) {
            BufferedImage downImg;
            BufferedImage img = Base.getImage("images/" + root + ".png", this);
            this.setIcon(new ImageIcon(img));
            BufferedImage overImg = Base.getImage("images/" + root + "Over.png", this);
            if (overImg != null) {
                this.setRolloverIcon(new ImageIcon(overImg));
                this.setRolloverEnabled(true);
            }
            if ((downImg = Base.getImage("images/" + root + "Down.png", this)) == null) {
                downImg = overImg;
            }
            if (downImg != null) {
                this.setSelectedIcon(new ImageIcon(downImg));
            }
            Dimension imgSize = new Dimension(img.getWidth(null), img.getHeight(null));
            this.setSize(imgSize);
            this.setMinimumSize(imgSize);
            this.setPreferredSize(imgSize);
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.setToolTipText(tooltip);
        }
    }
}

