/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.exceptions.SerialException;
import replicatorg.app.tools.XML;
import replicatorg.app.util.serial.Serial;
import replicatorg.app.util.serial.SerialFifoEventListener;
import replicatorg.drivers.DriverBaseImplementation;
import replicatorg.drivers.UsesSerial;

public class SerialDriver
extends DriverBaseImplementation
implements UsesSerial {
    protected Serial serial;
    private String portName;
    private int rate;
    private char parity;
    private int databits;
    private int stopbits;
    private boolean explicit = false;
    private final ReentrantReadWriteLock serialLock = new ReentrantReadWriteLock();
    public final ReentrantReadWriteLock.ReadLock serialInUse = this.serialLock.readLock();

    protected SerialDriver() {
        this.portName = Base.preferences.get("serial.portname", null);
        this.rate = Base.preferences.getInt("serial.debug_rate", 19200);
        String parityStr = Base.preferences.get("serial.parity", "N");
        this.parity = parityStr == null || parityStr.length() < 1 ? (char)78 : parityStr.charAt(0);
        this.databits = Base.preferences.getInt("serial.databits", 8);
        this.stopbits = Base.preferences.getInt("serial.stopbits", 1);
    }

    @Override
    public void loadXML(Node xml) {
        super.loadXML(xml);
        if (XML.hasChildNode(xml, "portname")) {
            this.portName = XML.getChildNodeValue(xml, "portname");
            this.explicit = true;
        }
        if (XML.hasChildNode(xml, "rate")) {
            this.rate = Integer.parseInt(XML.getChildNodeValue(xml, "rate"));
        }
        if (XML.hasChildNode(xml, "parity")) {
            this.parity = XML.getChildNodeValue(xml, "parity").charAt(0);
        }
        if (XML.hasChildNode(xml, "databits")) {
            this.databits = Integer.parseInt(XML.getChildNodeValue(xml, "databits"));
        }
        if (XML.hasChildNode(xml, "stopbits")) {
            this.stopbits = Integer.parseInt(XML.getChildNodeValue(xml, "stopbits"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void openSerial(String portName) {
        this.serialLock.writeLock().lock();
        Serial newConnection = null;
        try {
            Base.logger.info("Connecting to machine using serial port: " + portName);
            newConnection = new Serial(portName, this.rate, this.parity, this.databits, this.stopbits);
        }
        catch (SerialException e) {
            String msg = e.getMessage();
            Base.logger.severe("Connection error: " + msg);
            this.setError("Connection error: " + msg);
        }
        if (newConnection != null) {
            if (this.serial != null) {
                Serial serial = this.serial;
                synchronized (serial) {
                    this.serial.dispose();
                    this.serial = null;
                }
            }
            this.setInitialized(false);
            this.serial = newConnection;
            if (this instanceof SerialFifoEventListener && this.serial != null) {
                this.serial.listener.set((SerialFifoEventListener)((Object)this));
            }
        }
        this.serialLock.writeLock().unlock();
    }

    @Override
    public void closeSerial() {
        this.serialLock.writeLock().lock();
        if (this.serial != null) {
            this.serial.dispose();
        }
        this.serial = null;
        this.serialLock.writeLock().unlock();
    }

    @Override
    public boolean isConnected() {
        return this.serial != null && this.serial.isConnected();
    }

    @Override
    public char getParity() {
        return this.parity;
    }

    @Override
    public String getPortName() {
        return this.portName;
    }

    @Override
    public int getDataBits() {
        return this.databits;
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    @Override
    public float getStopBits() {
        return this.stopbits;
    }

    @Override
    public boolean isExplicit() {
        return this.explicit;
    }

    @Override
    public void dispose() {
        this.closeSerial();
        super.dispose();
    }
}

