/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine.builder;

import java.io.FileNotFoundException;
import java.io.IOException;
import replicatorg.app.Base;
import replicatorg.drivers.Driver;
import replicatorg.drivers.SDCardCapture;
import replicatorg.drivers.SimulationDriver;
import replicatorg.machine.Machine;
import replicatorg.machine.builder.Direct;
import replicatorg.machine.builder.MachineBuilder;
import replicatorg.model.GCodeSource;

public class ToLocalFile
implements MachineBuilder {
    Direct directBuilder;
    SDCardCapture sdcc;

    public ToLocalFile(Driver driver, SimulationDriver simulator, GCodeSource source, String remoteName) {
        this.sdcc = (SDCardCapture)((Object)driver);
        try {
            this.sdcc.beginFileCapture(remoteName);
        }
        catch (FileNotFoundException e) {
            Base.logger.fine("error!");
        }
        this.directBuilder = new Direct(driver, simulator, source);
    }

    @Override
    public boolean finished() {
        if (!this.directBuilder.finished()) {
            return false;
        }
        try {
            this.sdcc.endFileCapture();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Base.logger.info("Finished writing to file!");
        return true;
    }

    @Override
    public void runNext() {
        this.directBuilder.runNext();
    }

    @Override
    public int getLinesTotal() {
        return this.directBuilder.getLinesTotal();
    }

    @Override
    public int getLinesProcessed() {
        return this.directBuilder.getLinesProcessed();
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public Machine.JobTarget getTarget() {
        return Machine.JobTarget.FILE;
    }
}

