/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath;

import java.awt.Frame;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import replicatorg.app.Base;
import replicatorg.model.Build;
import replicatorg.model.BuildCode;
import replicatorg.plugin.toolpath.ProgressDialog;
import replicatorg.plugin.toolpath.ToolpathGenerator;

public class ToolpathGeneratorThread
extends Thread {
    private Frame parent;
    private ToolpathGenerator generator;
    private Build build;

    public ToolpathGeneratorThread(Frame parent, ToolpathGenerator generator, Build build) {
        this.parent = parent;
        this.generator = generator;
        this.build = build;
    }

    public void addListener(ToolpathGenerator.GeneratorListener listener) {
        this.generator.addListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block20: {
            this.generator.setModel(this.build.getModel());
            ProgressDialog progressDialog = null;
            if (this.parent != null) {
                progressDialog = new ProgressDialog(this.parent, this.build, this);
                if (!this.generator.visualConfigure(this.parent)) {
                    return;
                }
                this.generator.addListener(progressDialog);
                final ProgressDialog pdHandle = progressDialog;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!pdHandle.isDone()) {
                            double x = ToolpathGeneratorThread.this.parent.getBounds().getCenterX();
                            double y = ToolpathGeneratorThread.this.parent.getBounds().getCenterY();
                            pdHandle.pack();
                            pdHandle.setLocation((int)(x -= (double)pdHandle.getWidth() / 2.0), (int)(y -= (double)pdHandle.getHeight() / 2.0));
                            pdHandle.setVisible(true);
                        }
                    }
                });
            }
            Base.logger.info("Beginning toolpath generation.");
            try {
                try {
                    BuildCode code = this.generator.generateToolpath();
                    if (code != null) {
                        this.build.reloadCode();
                        this.generator.emitCompletion(ToolpathGenerator.GeneratorListener.Completion.SUCCESS, null);
                        Base.logger.info("Toolpath generation complete!");
                    } else {
                        this.generator.emitCompletion(ToolpathGenerator.GeneratorListener.Completion.FAILURE, null);
                        Base.logger.severe("Toolpath generation failed!");
                    }
                }
                catch (Exception e) {
                    Base.logger.log(Level.SEVERE, "Toolpath generation failed!", e);
                    this.generator.emitCompletion(ToolpathGenerator.GeneratorListener.Completion.FAILURE, e);
                    if (progressDialog == null) break block20;
                    ProgressDialog progressDialog2 = progressDialog;
                    synchronized (progressDialog2) {
                        progressDialog.setVisible(false);
                        progressDialog.setDone(true);
                        break block20;
                    }
                }
            }
            catch (Throwable throwable) {
                if (progressDialog != null) {
                    ProgressDialog progressDialog3 = progressDialog;
                    synchronized (progressDialog3) {
                        progressDialog.setVisible(false);
                        progressDialog.setDone(true);
                    }
                }
                throw throwable;
            }
            if (progressDialog != null) {
                ProgressDialog progressDialog4 = progressDialog;
                synchronized (progressDialog4) {
                    progressDialog.setVisible(false);
                    progressDialog.setDone(true);
                }
            }
        }
    }
}

