/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.skeinforge;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.SavingTextField;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;

public class PrintOMatic
implements SkeinforgeGenerator.SkeinforgePreference {
    private JPanel component = new JPanel((LayoutManager)new MigLayout("ins 0, fillx, hidemode 1"));
    private JCheckBox enabled;
    private String baseName = "replicatorg.skeinforge.printOMatic.";
    JTabbedPane printOMatic;

    private void addTextParameter(JComponent target, String name, String description, String defaultValue, String toolTip) {
        String fullName = String.valueOf(this.baseName) + name;
        String value = null;
        if (fullName != null) {
            value = Base.preferences.get(fullName, defaultValue);
            Base.preferences.put(fullName, value);
        }
        target.add(new JLabel(description));
        SavingTextField input = new SavingTextField(fullName, value, 10);
        target.add((Component)input, "wrap");
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    private void addDropDownParameter(JComponent target, String name, String description, Vector<String> options, String toolTip) {
        String fullName = String.valueOf(this.baseName) + name;
        String value = null;
        if (fullName != null) {
            value = Base.preferences.get(fullName, options.firstElement());
            Base.preferences.put(fullName, value);
        }
        target.add(new JLabel(description));
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(options);
        model.setSelectedItem(value);
        JComboBox<String> input = new JComboBox<String>(model);
        target.add(input, "wrap");
        input.addActionListener(new ComboListener(model, fullName));
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    private double getValue(String optionName) {
        String value = Base.preferences.get(String.valueOf(this.baseName) + optionName, null);
        Base.logger.fine("Saved value for preference " + this.baseName + optionName + " is " + value);
        Double number = null;
        try {
            number = Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            Base.logger.severe("Print-O-Matic setting " + optionName + "does not contain a valid number, please correct this!");
        }
        return number;
    }

    private double getScalingFactor() {
        String value = Base.preferences.get(String.valueOf(this.baseName) + "materialType", null);
        double scalingFactor = 1.0;
        if (value.equals("ABS")) {
            scalingFactor = 0.85;
        } else if (value.equals("PLA")) {
            scalingFactor = 1.0;
        } else {
            Base.logger.severe("Couldn't determine scaling factor for material " + value + ", defaulting to 1");
        }
        return scalingFactor;
    }

    public PrintOMatic() {
        final String enabledName = String.valueOf(this.baseName) + "enabled";
        this.enabled = new JCheckBox("Use Print-O-Matic (stepper extruders only)", Base.preferences.getBoolean(enabledName, false));
        this.enabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (enabledName != null) {
                    Base.preferences.putBoolean(enabledName, PrintOMatic.this.enabled.isSelected());
                    PrintOMatic.this.printOMatic.setVisible(PrintOMatic.this.enabled.isSelected());
                }
            }
        });
        this.component.add((Component)this.enabled, "wrap, spanx");
        this.printOMatic = new JTabbedPane();
        JPanel printPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        JPanel materialPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        JPanel machinePanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.addTextParameter(printPanel, "infillPercent", "Object infill (%)", "30", "0= hollow object, 100=solid object");
        this.addTextParameter(printPanel, "desiredLayerHeight", "Layer Height (mm)", "0.35", "Set the desired feedrate");
        this.addTextParameter(printPanel, "numberOfShells", "Number of shells:", "1", "Number of shells to add to the perimeter of an object. Set this to 0 if you are printing a model with thin features.");
        this.addTextParameter(printPanel, "desiredFeedrate", "Feedrate (mm/s)", "30", "slow: 0-20, default: 30, Fast: 40+");
        Vector<String> materialTypes = new Vector<String>();
        materialTypes.add("ABS");
        materialTypes.add("PLA");
        this.addDropDownParameter(materialPanel, "materialType", "Material type:", materialTypes, "Select the type of plastic to use during print");
        this.addTextParameter(materialPanel, "filamentDiameter", "Filament Diameter (mm)", "2.94", "measure feedstock");
        this.addTextParameter(machinePanel, "nozzleDiameter", "Nozzle Diameter (mm)", "0.5", "exit hole diameter");
        this.addTextParameter(machinePanel, "driveGearDiameter", "Drive Gear Diameter (mm)", "10.58", "measure at teeth");
        this.printOMatic.addTab("Settings", printPanel);
        this.printOMatic.addTab("Plastic", materialPanel);
        this.printOMatic.addTab("Extruder", machinePanel);
        this.component.add((Component)this.printOMatic, "spanx");
        this.printOMatic.setVisible(this.enabled.isSelected());
    }

    @Override
    public JComponent getUI() {
        return this.component;
    }

    @Override
    public String valueSanityCheck() {
        if (this.enabled.isSelected()) {
            if (this.calculateWidthOverThickness() > 1.8) {
                return "Layer height is smaller than recommended for the specified nozzle. Try increasing the layer height, or changing to a smaller nozzle.";
            }
            if (this.calculateWidthOverThickness() < 1.2) {
                return "Layer height is larger than recommended for the specified nozzle. Try decreasing the layer height, or changing to a larger nozzle.";
            }
        }
        return null;
    }

    public double calculateWidthOverThickness() {
        return Math.pow(this.getValue("nozzleDiameter") / 2.0, 2.0) * Math.PI / this.getValue("desiredLayerHeight") / this.getValue("desiredLayerHeight");
    }

    @Override
    public List<SkeinforgeGenerator.SkeinforgeOption> getOptions() {
        LinkedList<SkeinforgeGenerator.SkeinforgeOption> options = new LinkedList<SkeinforgeGenerator.SkeinforgeOption>();
        if (this.enabled.isSelected()) {
            double infillRatio = this.getValue("infillPercent") / 100.0;
            double flowRate = Math.pow(this.getValue("nozzleDiameter") / 2.0, 2.0) * Math.PI * this.getValue("desiredFeedrate") * 60.0 / (Math.pow(this.getValue("filamentDiameter") / 2.0, 2.0) * Math.PI * (this.getScalingFactor() * this.getValue("driveGearDiameter") * Math.PI));
            double perimeterWidthOverThickness = this.calculateWidthOverThickness();
            double infillWidthOverThickness = this.calculateWidthOverThickness();
            double feedRate = this.getValue("desiredFeedrate");
            double layerHeight = this.getValue("desiredLayerHeight");
            double extraShellsOnAlternatingSolidLayer = this.getValue("numberOfShells");
            double extraShellsOnBase = this.getValue("numberOfShells");
            double extraShellsOnSparseLayer = this.getValue("numberOfShells");
            Base.logger.fine("Print-O-Matic settings:\n infillRatio=" + infillRatio + "\n flowRate=" + flowRate + "\n perimeterWidthOverThickness=" + perimeterWidthOverThickness + "\n infillWidthOverThickness=" + infillWidthOverThickness + "\n feedRate=" + feedRate + "\n layerHeight=" + layerHeight + "\n extraShellsOnAlternatingSolidLayer=" + extraShellsOnAlternatingSolidLayer + "\n extraShellsOnBase=" + extraShellsOnBase + "\n extraShellsOnSparseLayer=" + extraShellsOnSparseLayer);
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Infill Solidity (ratio):", Double.toString(infillRatio)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("speed.csv", "Flow Rate Setting (float):", Double.toString(flowRate)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("carve.csv", "Perimeter Width over Thickness (ratio):", Double.toString(perimeterWidthOverThickness)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Infill Width over Thickness (ratio):", Double.toString(infillWidthOverThickness)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("speed.csv", "Feed Rate (mm/s):", Double.toString(feedRate)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("carve.csv", "Layer Thickness (mm):", Double.toString(layerHeight)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Alternating Solid Layer (layers):", Double.toString(extraShellsOnAlternatingSolidLayer)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Base (layers):", Double.toString(extraShellsOnBase)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Sparse Layer (layers):", Double.toString(extraShellsOnSparseLayer)));
        }
        return options;
    }

    private class ComboListener
    implements ActionListener {
        final String name;
        final DefaultComboBoxModel input;

        public ComboListener(DefaultComboBoxModel input, String name) {
            this.input = input;
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String value = this.input.getSelectedItem().toString();
            if (this.name != null) {
                Base.logger.fine("here: " + this.name + "=" + value);
                Base.preferences.put(this.name, value);
            }
        }
    }
}

