/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.skeinforge;

import java.io.File;
import java.io.IOException;
import replicatorg.app.Base;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;

public class ProfileUtils {
    public boolean delete(SkeinforgeGenerator.Profile p) {
        return this.delete(new File(p.getFullPath()));
    }

    private boolean delete(File file) {
        boolean result = true;
        if (file.exists()) {
            if (file.isDirectory()) {
                try {
                    if (!file.getAbsolutePath().equals(file.getCanonicalPath())) {
                        return false;
                    }
                }
                catch (IOException ioe) {
                    return false;
                }
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    result = result && this.delete(f);
                    ++n2;
                }
            }
            return result && file.delete();
        }
        return false;
    }

    public boolean openFolder(SkeinforgeGenerator.Profile p) {
        return this.openFolder(new File(p.getFullPath()));
    }

    private boolean openFolder(File file) {
        if (!Base.openFolderAvailable()) {
            Base.logger.info("The profile can be found in this directory: \"" + file + "\".");
            return false;
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                Base.logger.fine("The profile can be found in this directory: " + file);
                Base.openFolder(file);
                return true;
            }
        } else {
            return false;
        }
        return false;
    }
}

