/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.uploader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import replicatorg.app.Base;
import replicatorg.app.util.serial.Serial;
import replicatorg.uploader.AbstractFirmwareUploader;

public class AvrdudeUploader
extends AbstractFirmwareUploader {
    String protocol = "stk500v1";
    boolean manualReset = false;
    String eepromPath = null;
    String uploadInstructions = null;

    public void setEeprom(String path) {
        this.eepromPath = path;
    }

    public String getEeprom() {
        return this.eepromPath;
    }

    @Override
    public String getUploadInstructions() {
        if (this.uploadInstructions != null) {
            return this.uploadInstructions;
        }
        if (this.manualReset) {
            return "Press the reset button on the target board and click the \"Upload\" button to update the firmware.  Try to press the reset button as soon as you click \"Upload\".";
        }
        return super.getUploadInstructions();
    }

    public void setManualreset(String val) {
        if (val == null) {
            return;
        }
        Base.logger.fine("Manual reset = " + val);
        if ("true".equalsIgnoreCase(val)) {
            this.manualReset = true;
        }
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public boolean upload() {
        Vector<String> commandDownloader = new Vector<String>();
        String avrBasePath = Base.getToolsPath();
        commandDownloader.add(String.valueOf(avrBasePath) + File.separator + "avrdude");
        commandDownloader.add("-C" + avrBasePath + File.separator + "avrdude.conf");
        commandDownloader.add("-c" + this.protocol);
        commandDownloader.add("-P" + (Base.isWindows() ? "\\\\.\\" : "") + this.serialName);
        commandDownloader.add("-b" + Integer.toString(this.serialSpeed));
        commandDownloader.add("-D");
        if (this.eepromPath != null) {
            commandDownloader.add("-Ueeprom:w:" + this.eepromPath + ":i");
        }
        commandDownloader.add("-Uflash:w:" + this.source + ":i");
        if (Base.preferences.getBoolean("upload.verbose", false)) {
            commandDownloader.add("-v");
            commandDownloader.add("-v");
            commandDownloader.add("-v");
            commandDownloader.add("-v");
        }
        commandDownloader.add("-p" + this.architecture);
        int result = -1;
        try {
            String[] commandArray = new String[commandDownloader.size()];
            commandDownloader.toArray(commandArray);
            if (Base.preferences.getBoolean("upload.verbose", true)) {
                int i = 0;
                while (i < commandArray.length) {
                    System.out.print(String.valueOf(commandArray[i]) + " ");
                    ++i;
                }
                System.out.println();
            }
            Serial serialPort = new Serial(this.serialName);
            serialPort.pulseRTSLow();
            serialPort.dispose();
            Process process = Runtime.getRuntime().exec(commandArray);
            boolean uploading = true;
            result = 0;
            new StreamDumper(process.getInputStream(), System.out).start();
            new StreamDumper(process.getErrorStream(), System.err).start();
            while (uploading) {
                try {
                    result = process.waitFor();
                    uploading = false;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (result != 0) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = -1;
        }
        return result == 0;
    }

    class StreamDumper
    extends Thread {
        InputStream in;
        OutputStream out;

        public StreamDumper(InputStream in, OutputStream out) {
            super("AVR uploader Stream Dumper");
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            while (true) {
                try {
                    int cnt;
                    while ((cnt = this.in.read(buffer)) != -1) {
                        if (cnt <= 0) continue;
                        this.out.write(buffer, 0, cnt);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

