/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.uploader.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.uploader.FirmwareVersion;

public class FirmwareSelectionPanel
extends JPanel {
    private static final long serialVersionUID = -7960056942500494572L;
    final JLabel description = new JLabel("<html><font color=\"gray\">Select a firmware version.</font></html>");

    public FirmwareSelectionPanel(Node selectedBoard, final FirmwareSelectionListener listener) {
        this.setLayout((LayoutManager)new MigLayout("fill", "", "[grow 0][grow 100]"));
        this.add((Component)new JLabel("Select the firmware version to install:"), "growy 0,wrap");
        final JList list = new JList(new FirmwareListModel(selectedBoard));
        list.setFixedCellHeight(30);
        JScrollPane scrollPane = new JScrollPane(list);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                if (list.getSelectedIndex() != -1) {
                    FirmwareVersion selectedVersion = (FirmwareVersion)list.getModel().getElementAt(list.getSelectedIndex());
                    listener.firmwareSelected(selectedVersion);
                    String descr = selectedVersion.getDescription();
                    descr = descr == null ? "<html><font color=\"gray\">No description available.</font></html>" : "<html>" + descr + "</html>";
                    FirmwareSelectionPanel.this.description.setText(descr);
                }
            }
        });
        this.add((Component)scrollPane, "width 50%");
        this.add((Component)this.description, "width 50%");
    }

    class FirmwareListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 3534926635920932686L;
        Vector<FirmwareVersion> versions = new Vector();

        public FirmwareListModel(Node selectedBoard) {
            NodeList nl = selectedBoard.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if ("firmware".equalsIgnoreCase(n.getNodeName())) {
                    this.versions.add(new FirmwareVersion(n));
                }
                ++i;
            }
        }

        @Override
        public Object getElementAt(int idx) {
            return this.versions.elementAt(idx);
        }

        @Override
        public int getSize() {
            return this.versions.size();
        }
    }

    static interface FirmwareSelectionListener {
        public void firmwareSelected(FirmwareVersion var1);
    }
}

