/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.uploader.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.app.Base;
import replicatorg.machine.MachineInterface;
import replicatorg.uploader.AbstractFirmwareUploader;
import replicatorg.uploader.AvrdudeUploader;
import replicatorg.uploader.FirmwareUploader;
import replicatorg.uploader.FirmwareVersion;
import replicatorg.uploader.ui.BoardSelectionPanel;
import replicatorg.uploader.ui.FirmwareSelectionPanel;
import replicatorg.uploader.ui.PortSelectionPanel;

public class UploaderDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -401692780113162450L;
    JButton nextButton;
    JPanel centralPanel;
    FirmwareUploader uploader;
    State state;
    Node selectedBoard = null;
    FirmwareVersion selectedVersion = null;
    String portName = null;

    public UploaderDialog(Frame parent, FirmwareUploader uploader) {
        super(parent, "Firmware upgrade", true);
        this.uploader = uploader;
        this.centralPanel = new JPanel(new BorderLayout());
        Container c = this.getContentPane();
        c.setLayout((LayoutManager)new MigLayout());
        Dimension panelSize = new Dimension(500, 180);
        this.centralPanel.setMinimumSize(panelSize);
        this.centralPanel.setMaximumSize(panelSize);
        c.add((Component)this.centralPanel, "wrap,spanx");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UploaderDialog.this.doCancel();
            }
        });
        c.add((Component)cancelButton, "tag cancel");
        this.nextButton = new JButton("Next >");
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(this);
        c.add((Component)this.nextButton, "tag ok");
        this.doBoardSelection();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void showPanel(JComponent panel) {
        this.centralPanel.removeAll();
        this.centralPanel.setLayout(new BorderLayout());
        this.centralPanel.add((Component)panel, "Center");
        panel.setVisible(true);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.state == State.SELECTING_BOARD) {
            this.doFirmwareSelection();
        } else if (this.state == State.SELECTING_FIRMWARE) {
            this.doPortSelection();
        } else if (this.state == State.SELECTING_PORT) {
            this.doUpload();
        }
    }

    public void doCancel() {
        this.dispose();
    }

    void doBoardSelection() {
        this.state = State.SELECTING_BOARD;
        this.nextButton.setEnabled(false);
        BoardSelectionPanel boardPanel = new BoardSelectionPanel(FirmwareUploader.getFirmwareDoc(), new BoardSelectionPanel.BoardSelectionListener(){

            @Override
            public void boardSelected(Node board) {
                UploaderDialog.this.selectedBoard = board;
                UploaderDialog.this.nextButton.setEnabled(true);
            }
        });
        this.showPanel(boardPanel);
    }

    void doFirmwareSelection() {
        this.state = State.SELECTING_FIRMWARE;
        this.nextButton.setEnabled(false);
        FirmwareSelectionPanel firmwarePanel = new FirmwareSelectionPanel(this.selectedBoard, new FirmwareSelectionPanel.FirmwareSelectionListener(){

            @Override
            public void firmwareSelected(FirmwareVersion firmware) {
                UploaderDialog.this.selectedVersion = firmware;
                UploaderDialog.this.nextButton.setEnabled(true);
            }
        });
        this.showPanel(firmwarePanel);
    }

    void doPortSelection() {
        this.state = State.SELECTING_PORT;
        this.nextButton.setEnabled(false);
        PortSelectionPanel portPanel = new PortSelectionPanel(new PortSelectionPanel.PortSelectionListener(){

            @Override
            public void portSelected(String port) {
                UploaderDialog.this.portName = port;
                UploaderDialog.this.nextButton.setEnabled(true);
            }
        });
        this.showPanel(portPanel);
    }

    AbstractFirmwareUploader createUploader() {
        MachineInterface machine = Base.getMachineLoader().getMachine();
        if (machine != null) {
            machine.dispose();
        }
        NodeList nl = this.selectedBoard.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if ("programmer".equalsIgnoreCase(n.getNodeName())) {
                return AbstractFirmwareUploader.makeUploader(n);
            }
            ++i;
        }
        return null;
    }

    void doUpload() {
        final AbstractFirmwareUploader uploader = this.createUploader();
        this.state = State.UPLOADING;
        this.nextButton.setEnabled(true);
        this.nextButton.setText("Upload");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("fill"));
        panel.add((Component)new JLabel("<html>" + uploader.getUploadInstructions() + "</html>"), "wrap");
        final String eepromPath = this.selectedVersion.getEepromPath();
        if (eepromPath != null) {
            final JCheckBox cbox = new JCheckBox("overwrite current EEPROM settings", true);
            cbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (cbox.isSelected()) {
                        UploaderDialog.this.selectedVersion.setEepromPath(eepromPath);
                    } else {
                        UploaderDialog.this.selectedVersion.setEepromPath(null);
                    }
                }
            });
            panel.add((Component)cbox, "wrap");
            String text = "Overwriting your eeprom will erase any changes you have made to your board settings.  If you've made changes you want to keep, either uncheck this box or note your parameters before overwriting.";
            panel.add((Component)new JLabel("<html><i>Overwriting your eeprom will erase any changes you have made to your board settings.  If you've made changes you want to keep, either uncheck this box or note your parameters before overwriting.</i></html>"), "wrap");
        }
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UploaderDialog.this.performUpload(uploader);
            }
        });
        this.showPanel(panel);
    }

    void performUpload(AbstractFirmwareUploader uploader) {
        if (uploader != null) {
            boolean success;
            uploader.setPortName(this.portName);
            String path = Base.getUserFile(this.selectedVersion.getRelPath()).getAbsolutePath();
            uploader.setSource(path);
            if (uploader instanceof AvrdudeUploader && this.selectedVersion.getEepromPath() != null) {
                String eepromPath = Base.getUserFile(this.selectedVersion.getEepromPath()).getAbsolutePath();
                ((AvrdudeUploader)uploader).setEeprom(eepromPath);
            }
            if (success = uploader.upload()) {
                JOptionPane.showMessageDialog(this, "Firmware update succeeded!", "Firmware Uploaded", 1);
                this.doCancel();
            } else {
                JOptionPane.showMessageDialog(this, "<html>The firmware update did not succeed.  Check the console for details.<br/>You can click the \"Upload\" button to try again.</html>", "Upload Failed", 0);
            }
        }
    }

    static enum State {
        SELECTING_BOARD,
        SELECTING_FIRMWARE,
        SELECTING_PORT,
        UPLOADING;

    }
}

