/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.CommandLineArgs;
import org.testng.IAnnotationTransformer;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IObjectFactory;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.ReporterConfig;
import org.testng.SuiteRunner;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.AnnotationTypeEnum;
import org.testng.internal.ClassHelper;
import org.testng.internal.IConfiguration;
import org.testng.internal.IResultListener;
import org.testng.internal.PoolService;
import org.testng.internal.TestNGGuiceModule;
import org.testng.internal.Utils;
import org.testng.internal.annotations.DefaultAnnotationTransformer;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.Sets;
import org.testng.internal.version.VersionInfo;
import org.testng.log4testng.Logger;
import org.testng.remote.SuiteDispatcher;
import org.testng.remote.SuiteSlave;
import org.testng.reporters.EmailableReporter;
import org.testng.reporters.FailedReporter;
import org.testng.reporters.SuiteHTMLReporter;
import org.testng.reporters.XMLReporter;
import org.testng.xml.Parser;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNG {
    private static final Logger LOGGER = Logger.getLogger(TestNG.class);
    public static final String DEFAULT_COMMAND_LINE_SUITE_NAME = "Command line suite";
    public static final String DEFAULT_COMMAND_LINE_TEST_NAME = "Command line test";
    public static final String DEFAULT_OUTPUTDIR = "test-output";
    public static final String SRC_SEPARATOR = ";";
    public static final String JDK_ANNOTATION_TYPE = AnnotationTypeEnum.JDK.getName();
    public static final String JAVADOC_ANNOTATION_TYPE = AnnotationTypeEnum.JAVADOC.getName();
    public static final String SHOW_TESTNG_STACK_FRAMES = "testng.show.stack.frames";
    public static final String TEST_CLASSPATH = "testng.test.classpath";
    private static TestNG m_instance;
    private static JCommander m_jCommander;
    private List<String> m_commandLineMethods;
    protected List<XmlSuite> m_suites = Lists.newArrayList();
    protected List<XmlSuite> m_cmdlineSuites;
    protected String m_outputDir = "test-output";
    protected String[] m_sourceDirs;
    private AnnotationTypeEnum m_defaultAnnotations = VersionInfo.getDefaultAnnotationType();
    protected String[] m_includedGroups;
    protected String[] m_excludedGroups;
    private Boolean m_isJUnit = Boolean.FALSE;
    protected boolean m_useDefaultListeners = true;
    protected ITestRunnerFactory m_testRunnerFactory;
    protected List<ITestListener> m_testListeners = Lists.newArrayList();
    protected List<ISuiteListener> m_suiteListeners = Lists.newArrayList();
    private Set<IReporter> m_reporters = Sets.newHashSet();
    public static final int HAS_FAILURE = 1;
    public static final int HAS_SKIPPED = 2;
    public static final int HAS_FSP = 4;
    public static final int HAS_NO_TEST = 8;
    protected int m_status;
    protected boolean m_hasTests = false;
    private String m_slavefileName = null;
    private String m_masterfileName = null;
    private int m_threadCount;
    private boolean m_useThreadCount;
    private String m_parallelMode;
    private boolean m_useParallelMode;
    private String m_configFailurePolicy;
    private Class[] m_commandLineTestClasses;
    private String m_defaultSuiteName = "Command line suite";
    private String m_defaultTestName = "Command line test";
    private Map<String, Integer> m_methodDescriptors = Maps.newHashMap();
    private IObjectFactory m_objectFactory;
    protected List<IInvokedMethodListener> m_invokedMethodListeners = Lists.newArrayList();
    private Integer m_dataProviderThreadCount = null;
    private String m_jarPath;
    private List<String> m_stringSuites = Lists.newArrayList();
    private int m_verbose = 1;
    private IAnnotationTransformer m_annotationTransformer = new DefaultAnnotationTransformer();
    private Boolean m_skipFailedInvocationCounts = false;
    private IMethodInterceptor m_methodInterceptor = null;
    private Injector m_injector;
    private List<String> m_testNames;

    public TestNG() {
        this.init(true);
    }

    public TestNG(boolean useDefaultListeners) {
        this.init(useDefaultListeners);
    }

    private void init(boolean useDefaultListeners) {
        m_instance = this;
        this.m_useDefaultListeners = useDefaultListeners;
    }

    public int getStatus() {
        return this.m_status;
    }

    protected void setStatus(int status) {
        this.m_status |= status;
    }

    public void setOutputDirectory(String outputdir) {
        if (null != outputdir && !"".equals(outputdir)) {
            this.m_outputDir = outputdir;
        }
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.m_useDefaultListeners = useDefaultListeners;
    }

    public void setAnnotations(String annotationType) {
        if (null != annotationType && !"".equals(annotationType)) {
            this.setAnnotations(AnnotationTypeEnum.valueOf(annotationType));
        }
    }

    private void setAnnotations(AnnotationTypeEnum annotationType) {
        if (null != annotationType) {
            this.m_defaultAnnotations = annotationType;
        }
    }

    public void setSourcePath(String sourcePaths) {
        LOGGER.debug("setSourcePath: \"" + sourcePaths + "\"");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("testng-sourcedir-override.properties");
        if (is != null) {
            Properties props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading testng-sourcedir-override.properties", e);
            }
            sourcePaths = props.getProperty("sourcedir");
            LOGGER.debug("setSourcePath ignoring sourcepath parameter and using testng-sourcedir-override.properties: \"" + sourcePaths + "\"");
        }
        if (null == sourcePaths || "".equals(sourcePaths.trim())) {
            return;
        }
        this.m_sourceDirs = Utils.split(sourcePaths, SRC_SEPARATOR);
    }

    public void setTestJar(String jarPath) {
        this.m_jarPath = jarPath;
    }

    public void initializeSuitesAndJarFile() {
        if (this.m_suites.size() > 0) {
            return;
        }
        for (String suiteXmlPath : this.m_stringSuites) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("suiteXmlPath: \"" + suiteXmlPath + "\"");
            }
            try {
                Collection<XmlSuite> allSuites = new Parser(suiteXmlPath).parse();
                for (XmlSuite s : allSuites) {
                    if (this.m_testNames != null) {
                        this.m_suites.add(TestNG.extractTestNames(s, this.m_testNames));
                        continue;
                    }
                    this.m_suites.add(s);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.out);
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace(System.out);
            }
            catch (SAXException e) {
                e.printStackTrace(System.out);
            }
        }
        if (this.m_jarPath != null && this.m_stringSuites.size() > 0) {
            StringBuilder suites = new StringBuilder();
            for (String s : this.m_stringSuites) {
                suites.append(s);
            }
            Utils.log("TestNG", 2, "Ignoring the XML file inside " + this.m_jarPath + " and using " + suites + " instead");
            return;
        }
        if (null == this.m_jarPath || "".equals(this.m_jarPath)) {
            return;
        }
        File jarFile = new File(this.m_jarPath);
        try {
            URL jarfileUrl = jarFile.getCanonicalFile().toURI().toURL();
            URLClassLoader jarLoader = new URLClassLoader(new URL[]{jarfileUrl});
            Thread.currentThread().setContextClassLoader(jarLoader);
            Utils.log("TestNG", 2, "Trying to open jar file:" + jarFile);
            JarFile jf = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jf.entries();
            List<String> classes = Lists.newArrayList();
            boolean foundTestngXml = false;
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                if (je.getName().equals("testng.xml")) {
                    Parser parser = new Parser(jf.getInputStream(je));
                    this.m_suites.addAll(parser.parse());
                    foundTestngXml = true;
                    break;
                }
                if (!je.getName().endsWith(".class")) continue;
                int n = je.getName().length() - ".class".length();
                classes.add(je.getName().replace("/", ".").substring(0, n));
            }
            if (!foundTestngXml) {
                XmlSuite xmlSuite = new XmlSuite();
                xmlSuite.setVerbose(0);
                xmlSuite.setName("Jar suite");
                XmlTest xmlTest = new XmlTest(xmlSuite);
                List<XmlClass> xmlClasses = Lists.newArrayList();
                for (String cls : classes) {
                    XmlClass xmlClass = new XmlClass(cls);
                    xmlClasses.add(xmlClass);
                }
                xmlTest.setXmlClasses(xmlClasses);
                this.m_suites.add(xmlSuite);
            }
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static XmlSuite extractTestNames(XmlSuite s, List<String> testNames) {
        List tests = Lists.newArrayList();
        for (XmlTest xt : s.getTests()) {
            for (String tn : testNames) {
                if (!xt.getName().equals(tn)) continue;
                tests.add(xt);
            }
        }
        if (tests.size() == 0) {
            return s;
        }
        XmlSuite result = (XmlSuite)s.clone();
        result.getTests().clear();
        result.getTests().addAll(tests);
        return result;
    }

    public void setThreadCount(int threadCount) {
        if (threadCount < 1) {
            TestNG.exitWithError("Cannot use a threadCount parameter less than 1; 1 > " + threadCount);
        }
        this.m_threadCount = threadCount;
        this.m_useThreadCount = true;
    }

    public void setParallel(String parallel) {
        this.m_parallelMode = parallel;
        this.m_useParallelMode = true;
    }

    public void setCommandLineSuite(XmlSuite suite) {
        this.m_cmdlineSuites = Lists.newArrayList();
        this.m_cmdlineSuites.add(suite);
        this.m_suites.add(suite);
    }

    public void setTestClasses(Class[] classes) {
        this.m_suites.clear();
        this.m_commandLineTestClasses = classes;
    }

    private String[] splitMethod(String m) {
        int index = m.lastIndexOf(".");
        if (index < 0) {
            throw new TestNGException("Bad format for command line method:" + m);
        }
        return new String[]{m.substring(0, index), m.substring(index + 1)};
    }

    private List<XmlSuite> createCommandLineSuitesForMethods(List<String> commandLineMethods) {
        Set classes = Sets.newHashSet();
        for (String m : commandLineMethods) {
            classes.add(ClassHelper.forName(this.splitMethod(m)[0]));
        }
        List<XmlSuite> result = this.createCommandLineSuitesForClasses(classes.toArray(new Class[0]));
        List<XmlClass> xmlClasses = result.get(0).getTests().get(0).getXmlClasses();
        for (XmlClass xc : xmlClasses) {
            for (String m : commandLineMethods) {
                String[] split = this.splitMethod(m);
                String className = split[0];
                if (!xc.getName().equals(className)) continue;
                XmlInclude includedMethod = new XmlInclude(split[1]);
                xc.getIncludedMethods().add(includedMethod);
            }
        }
        return result;
    }

    private List<XmlSuite> createCommandLineSuitesForClasses(Class[] classes) {
        XmlClass[] xmlClasses = Utils.classesToXmlClasses(classes);
        Map<String, XmlSuite> suites = Maps.newHashMap();
        IAnnotationFinder finder = this.getAnnotationFinder();
        for (int i = 0; i < classes.length; ++i) {
            XmlSuite xmlSuite;
            Class c = classes[i];
            ITestAnnotation test = (ITestAnnotation)finder.findAnnotation(c, ITestAnnotation.class);
            String suiteName = this.getDefaultSuiteName();
            String testName = this.getDefaultTestName();
            if (test != null) {
                String candidateTestName;
                String candidateSuiteName = test.getSuiteName();
                if (candidateSuiteName != null && !"".equals(candidateSuiteName)) {
                    suiteName = candidateSuiteName;
                }
                if ((candidateTestName = test.getTestName()) != null && !"".equals(candidateTestName)) {
                    testName = candidateTestName;
                }
            }
            if ((xmlSuite = (XmlSuite)suites.get(suiteName)) == null) {
                xmlSuite = new XmlSuite();
                xmlSuite.setName(suiteName);
                suites.put(suiteName, xmlSuite);
            }
            if (this.m_dataProviderThreadCount != null) {
                xmlSuite.setDataProviderThreadCount(this.m_dataProviderThreadCount);
            }
            XmlTest xmlTest = null;
            for (XmlTest xt : xmlSuite.getTests()) {
                if (!xt.getName().equals(testName)) continue;
                xmlTest = xt;
                break;
            }
            if (xmlTest == null) {
                xmlTest = new XmlTest(xmlSuite);
                xmlTest.setName(testName);
            }
            xmlTest.getXmlClasses().add(xmlClasses[i]);
        }
        return new ArrayList<XmlSuite>(suites.values());
    }

    public void addMethodSelector(String className, int priority) {
        this.m_methodDescriptors.put(className, priority);
    }

    public void setTestSuites(List<String> suites) {
        this.m_stringSuites = suites;
    }

    public void setXmlSuites(List<XmlSuite> suites) {
        this.m_suites = suites;
    }

    public void setExcludedGroups(String groups) {
        this.m_excludedGroups = Utils.split(groups, ",");
    }

    public void setGroups(String groups) {
        this.m_includedGroups = Utils.split(groups, ",");
    }

    protected void setTestRunnerFactoryClass(Class testRunnerFactoryClass) {
        this.setTestRunnerFactory((ITestRunnerFactory)ClassHelper.newInstance(testRunnerFactoryClass));
    }

    protected void setTestRunnerFactory(ITestRunnerFactory itrf) {
        this.m_testRunnerFactory = itrf;
    }

    public void setObjectFactory(Class c) {
        this.m_objectFactory = (IObjectFactory)ClassHelper.newInstance(c);
    }

    public void setObjectFactory(IObjectFactory factory) {
        this.m_objectFactory = factory;
    }

    public void setListenerClasses(List<Class> classes) {
        for (Class cls : classes) {
            this.addListener(ClassHelper.newInstance(cls));
        }
    }

    public void addListener(Object listener) {
        if (!(listener instanceof ITestNGListener)) {
            TestNG.exitWithError("Listener " + listener + " must be one of ITestListener, ISuiteListener, IReporter, " + " IAnnotationTransformer, IMethodInterceptor or IInvokedMethodListener");
        } else {
            if (listener instanceof ISuiteListener) {
                this.addListener((ISuiteListener)listener);
            }
            if (listener instanceof ITestListener) {
                this.addListener((ITestListener)listener);
            }
            if (listener instanceof IReporter) {
                this.addListener((IReporter)listener);
            }
            if (listener instanceof IAnnotationTransformer) {
                this.setAnnotationTransformer((IAnnotationTransformer)listener);
            }
            if (listener instanceof IMethodInterceptor) {
                this.m_methodInterceptor = (IMethodInterceptor)listener;
            }
            if (listener instanceof IInvokedMethodListener) {
                this.addInvokedMethodListener((IInvokedMethodListener)listener);
            }
        }
    }

    public void addListener(IInvokedMethodListener listener) {
        this.m_invokedMethodListeners.add(listener);
    }

    public void addListener(ISuiteListener listener) {
        if (null != listener) {
            this.m_suiteListeners.add(listener);
        }
    }

    public void addListener(ITestListener listener) {
        if (null != listener) {
            this.m_testListeners.add(listener);
        }
    }

    public void addListener(IReporter listener) {
        if (null != listener) {
            this.m_reporters.add(listener);
        }
    }

    public void addInvokedMethodListener(IInvokedMethodListener listener) {
        this.m_invokedMethodListeners.add(listener);
    }

    public Set<IReporter> getReporters() {
        return this.m_reporters;
    }

    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    public List<ISuiteListener> getSuiteListeners() {
        return this.m_suiteListeners;
    }

    public void setVerbose(int verbose) {
        this.m_verbose = verbose;
    }

    private void initializeCommandLineSuites() {
        if (this.m_commandLineTestClasses != null || this.m_commandLineMethods != null) {
            this.initializeInjector();
            this.m_cmdlineSuites = null != this.m_commandLineMethods ? this.createCommandLineSuitesForMethods(this.m_commandLineMethods) : this.createCommandLineSuitesForClasses(this.m_commandLineTestClasses);
            for (XmlSuite s : this.m_cmdlineSuites) {
                this.m_suites.add(s);
            }
        }
    }

    private void initializeCommandLineSuitesParams() {
        if (null == this.m_cmdlineSuites) {
            return;
        }
        for (XmlSuite s : this.m_cmdlineSuites) {
            if (this.m_useThreadCount) {
                s.setThreadCount(this.m_threadCount);
            }
            if (this.m_useParallelMode) {
                s.setParallel(this.m_parallelMode);
            }
            if (this.m_configFailurePolicy == null) continue;
            s.setConfigFailurePolicy(this.m_configFailurePolicy.toString());
        }
    }

    private void initializeCommandLineSuitesGroups() {
        if (null != this.m_cmdlineSuites) {
            for (XmlSuite s : this.m_cmdlineSuites) {
                if (null != this.m_includedGroups && this.m_includedGroups.length > 0) {
                    s.getTests().get(0).setIncludedGroups(Arrays.asList(this.m_includedGroups));
                }
                if (null == this.m_excludedGroups || this.m_excludedGroups.length <= 0) continue;
                s.getTests().get(0).setExcludedGroups(Arrays.asList(this.m_excludedGroups));
            }
        }
    }

    private void addReporter(Class<? extends IReporter> r) {
        if (!this.m_reporters.contains(r)) {
            this.m_reporters.add(ClassHelper.newInstance(r));
        }
    }

    private void initializeDefaultListeners() {
        this.m_testListeners.add(new ExitCodeListener(this));
        if (this.m_useDefaultListeners) {
            this.addReporter(SuiteHTMLReporter.class);
            this.addReporter(FailedReporter.class);
            this.addReporter(XMLReporter.class);
            this.addReporter(EmailableReporter.class);
        }
    }

    private void initializeInjector() {
        TestNGGuiceModule module = new TestNGGuiceModule(this.getAnnotationTransformer(), this.m_objectFactory);
        this.m_injector = Guice.createInjector(module);
    }

    public void run() {
        this.initializeSuitesAndJarFile();
        this.initializeDefaultListeners();
        this.initializeCommandLineSuites();
        this.initializeCommandLineSuitesParams();
        this.initializeCommandLineSuitesGroups();
        List<ISuite> suiteRunners = null;
        if (this.m_slavefileName != null) {
            SuiteSlave slave = new SuiteSlave(this.m_slavefileName, this);
            slave.waitForSuites();
        } else if (this.m_masterfileName == null) {
            suiteRunners = this.runSuitesLocally();
        } else {
            SuiteDispatcher dispatcher = new SuiteDispatcher(this.m_masterfileName);
            suiteRunners = dispatcher.dispatch(this.m_injector.getInstance(IConfiguration.class), this.m_suites, this.getOutputDirectory(), this.getTestListeners());
        }
        this.initializeInjector();
        if (null != suiteRunners) {
            this.generateReports(suiteRunners);
        }
        if (!this.m_hasTests) {
            this.setStatus(8);
            if (TestRunner.getVerbose() > 1) {
                System.err.println("[TestNG] No tests found. Nothing was run");
                TestNG.usage();
            }
        }
    }

    private static void usage() {
        m_jCommander.usage();
    }

    private void generateReports(List<ISuite> suiteRunners) {
        for (IReporter reporter : this.m_reporters) {
            try {
                reporter.generateReport(this.m_suites, suiteRunners, this.m_outputDir);
            }
            catch (Exception ex) {
                System.err.println("[TestNG] Reporter " + reporter + " failed");
                ex.printStackTrace(System.err);
            }
        }
    }

    public List<ISuite> runSuitesLocally() {
        Map<XmlSuite, ISuite> suiteRunnerMap = Maps.newHashMap();
        if (this.m_suites.size() > 0) {
            for (XmlSuite xmlSuite : this.m_suites) {
                this.createSuiteRunners(suiteRunnerMap, xmlSuite);
            }
            for (XmlSuite xmlSuite : this.m_suites) {
                this.runSuite(suiteRunnerMap, xmlSuite);
            }
        } else {
            this.setStatus(8);
            System.err.println("[ERROR]: No test suite found. Nothing to run");
            TestNG.usage();
        }
        return Lists.newArrayList(suiteRunnerMap.values());
    }

    private void createSuiteRunners(Map<XmlSuite, ISuite> suiteRunnerMap, XmlSuite xmlSuite) {
        xmlSuite.setDefaultAnnotations(this.m_defaultAnnotations.toString());
        if (null != this.m_isJUnit) {
            xmlSuite.setJUnit(this.m_isJUnit);
        }
        for (String listenerName : xmlSuite.getListeners()) {
            Class<?> listenerClass = ClassHelper.forName(listenerName);
            if (listenerClass == null) {
                throw new TestNGException("Listener " + listenerName + " was not found in project's classpath");
            }
            Object listener = ClassHelper.newInstance(listenerClass);
            this.addListener(listener);
        }
        if (null != this.m_skipFailedInvocationCounts) {
            xmlSuite.setSkipFailedInvocationCounts(this.m_skipFailedInvocationCounts);
        }
        if (xmlSuite.getVerbose() == null) {
            xmlSuite.setVerbose(this.m_verbose);
        }
        if (null != this.m_configFailurePolicy) {
            xmlSuite.setConfigFailurePolicy(this.m_configFailurePolicy);
        }
        for (XmlTest t : xmlSuite.getTests()) {
            for (Map.Entry<String, Integer> ms : this.m_methodDescriptors.entrySet()) {
                XmlMethodSelector xms = new XmlMethodSelector();
                xms.setName(ms.getKey());
                xms.setPriority(ms.getValue());
                t.getMethodSelectors().add(xms);
            }
        }
        suiteRunnerMap.put(xmlSuite, this.createSuiteRunner(xmlSuite));
        for (XmlSuite childSuite : xmlSuite.getChildSuites()) {
            this.createSuiteRunners(suiteRunnerMap, childSuite);
        }
    }

    protected SuiteRunner createSuiteRunner(XmlSuite xmlSuite) {
        this.initializeInjector();
        SuiteRunner result = new SuiteRunner(this.getConfiguration(), xmlSuite, this.m_outputDir, this.m_testRunnerFactory, this.m_useDefaultListeners, this.m_methodInterceptor, this.m_invokedMethodListeners, this.m_testListeners);
        for (ISuiteListener isl : this.m_suiteListeners) {
            result.addListener(isl);
        }
        return result;
    }

    private void runSuite(Map<XmlSuite, ISuite> suiteRunnerMap, XmlSuite xmlSuite) {
        if (this.m_verbose > 0) {
            StringBuffer allFiles = new StringBuffer();
            allFiles.append("  ").append(xmlSuite.getFileName() != null ? xmlSuite.getFileName() : this.getDefaultSuiteName()).append('\n');
            Utils.log("TestNG", 0, "Running:\n" + allFiles.toString());
        }
        PoolService.initialize(xmlSuite.getDataProviderThreadCount());
        SuiteRunner suiteRunner = (SuiteRunner)suiteRunnerMap.get(xmlSuite);
        suiteRunner.run();
        for (IReporter r : suiteRunner.getReporters()) {
            this.addListener(r);
        }
        for (XmlSuite childSuite : xmlSuite.getChildSuites()) {
            this.runSuite(suiteRunnerMap, childSuite);
        }
        if (xmlSuite.getVerbose() > 0) {
            SuiteResultCounts counts = new SuiteResultCounts();
            counts.calculateResultCounts(xmlSuite, suiteRunnerMap);
            StringBuffer bufLog = new StringBuffer(xmlSuite.getName());
            bufLog.append("\nTotal tests run: ").append(counts.total).append(", Failures: ").append(counts.failed).append(", Skips: ").append(counts.skipped);
            if (counts.confFailures > 0 || counts.confSkips > 0) {
                bufLog.append("\nConfiguration Failures: ").append(counts.confFailures).append(", Skips: ").append(counts.confSkips);
            }
            System.out.println("\n===============================================\n" + bufLog.toString() + "\n===============================================\n");
        }
    }

    private IAnnotationFinder getAnnotationFinder() {
        return this.m_injector.getInstance(IAnnotationFinder.class);
    }

    private IConfiguration getConfiguration() {
        return this.m_injector.getInstance(IConfiguration.class);
    }

    public static void main(String[] argv) {
        TestNG testng = TestNG.privateMain(argv, null);
        System.exit(testng.getStatus());
    }

    public static TestNG privateMain(String[] argv, ITestListener listener) {
        TestNG result = new TestNG();
        if (null != listener) {
            result.addListener(listener);
        }
        try {
            CommandLineArgs cla = new CommandLineArgs();
            m_jCommander = new JCommander((Object)cla, argv);
            TestNG.validateCommandLineParameters(cla);
            result.configure(cla);
        }
        catch (ParameterException ex) {
            TestNG.exitWithError(ex.getMessage());
        }
        try {
            result.run();
        }
        catch (TestNGException ex) {
            if (TestRunner.getVerbose() > 1) {
                ex.printStackTrace(System.out);
            } else {
                System.err.println("[ERROR]: " + ex.getMessage());
            }
            result.setStatus(1);
        }
        return result;
    }

    protected void configure(CommandLineArgs cla) {
        if (cla.verbose != null) {
            this.setVerbose(cla.verbose);
        }
        this.setOutputDirectory(cla.outputDirectory);
        String testClasses = cla.testClass;
        if (null != testClasses) {
            String[] strClasses = testClasses.split(",");
            List classes = Lists.newArrayList();
            for (String c : strClasses) {
                classes.add(ClassHelper.fileToClass(c));
            }
            this.setTestClasses(classes.toArray(new Class[classes.size()]));
        }
        this.setOutputDirectory(cla.outputDirectory);
        if (cla.testNames != null) {
            this.setTestNames(Arrays.asList(cla.testNames.split(",")));
        }
        if (cla.useDefaultListeners != null) {
            this.setUseDefaultListeners("true".equalsIgnoreCase(cla.useDefaultListeners));
        }
        this.setGroups(cla.groups);
        this.setExcludedGroups(cla.excludedGroups);
        this.setTestJar(cla.testJar);
        this.setJUnit(cla.junit);
        this.setMaster(cla.master);
        this.setSlave(cla.slave);
        this.setSkipFailedInvocationCounts(cla.skipFailedInvocationCounts);
        if (cla.parallelMode != null) {
            this.setParallel(cla.parallelMode);
        }
        if (cla.configFailurePolicy != null) {
            this.setConfigFailurePolicy(cla.configFailurePolicy);
        }
        if (cla.threadCount != null) {
            this.setThreadCount(cla.threadCount);
        }
        if (cla.dataProviderThreadCount != null) {
            this.setDataProviderThreadCount(cla.dataProviderThreadCount);
        }
        if (cla.suiteName != null) {
            this.setDefaultSuiteName(cla.suiteName);
        }
        if (cla.testName != null) {
            this.setDefaultTestName(cla.testName);
        }
        if (cla.listener != null) {
            String sep = SRC_SEPARATOR;
            if (cla.listener.indexOf(",") >= 0) {
                sep = ",";
            }
            String[] strs = Utils.split(cla.listener, sep);
            List<Class> classes = Lists.newArrayList();
            for (String cls : strs) {
                classes.add(ClassHelper.fileToClass(cls));
            }
            this.setListenerClasses(classes);
        }
        if (null != cla.methodSelectors) {
            String[] strs;
            for (String cls : strs = Utils.split(cla.methodSelectors, ",")) {
                String[] sel = Utils.split(cls, ":");
                try {
                    if (sel.length == 2) {
                        this.addMethodSelector(sel[0], Integer.valueOf(sel[1]));
                        continue;
                    }
                    LOGGER.error("ERROR: method selector value was not in the format org.example.Selector:4");
                }
                catch (NumberFormatException nfe) {
                    LOGGER.error("ERROR: method selector value was not in the format org.example.Selector:4");
                }
            }
        }
        if (cla.objectFactory != null) {
            this.setObjectFactory(ClassHelper.fileToClass(cla.objectFactory));
        }
        if (cla.testRunnerFactory != null) {
            this.setTestRunnerFactoryClass(ClassHelper.fileToClass(cla.testRunnerFactory));
        }
        if (cla.reportersList != null) {
            ReporterConfig reporterConfig = ReporterConfig.deserialize(cla.reportersList);
            this.addReporter(reporterConfig);
        }
        if (cla.commandLineMethods.size() > 0) {
            this.m_commandLineMethods = cla.commandLineMethods;
        }
        if (cla.suiteFiles != null) {
            this.setTestSuites(cla.suiteFiles);
        }
    }

    public void configure(Map cmdLineArgs) {
        String failurePolicy;
        String reporterConfigs;
        String runnerFactory;
        String objectFactory;
        String ms;
        String strClass;
        String defaultTestName;
        String defaultSuiteName;
        Integer dptc;
        Integer threadCount;
        String useDefaultListeners;
        String testNames;
        CommandLineArgs result = new CommandLineArgs();
        Integer verbose = (Integer)cmdLineArgs.get("-log");
        if (null != verbose) {
            result.verbose = verbose;
        }
        result.outputDirectory = (String)cmdLineArgs.get("-d");
        String testClasses = (String)cmdLineArgs.get("-testclass");
        if (null != testClasses) {
            result.testClass = testClasses;
        }
        if ((testNames = (String)cmdLineArgs.get("-testnames")) != null) {
            result.testNames = testNames;
        }
        if (null != (useDefaultListeners = (String)cmdLineArgs.get("-usedefaultlisteners"))) {
            result.useDefaultListeners = useDefaultListeners;
        }
        result.groups = (String)cmdLineArgs.get("-groups");
        result.excludedGroups = (String)cmdLineArgs.get("-excludegroups");
        result.testJar = (String)cmdLineArgs.get("-testjar");
        result.junit = (Boolean)cmdLineArgs.get("-junit");
        result.master = (String)cmdLineArgs.get("-master");
        result.slave = (String)cmdLineArgs.get("-slave");
        result.skipFailedInvocationCounts = (Boolean)cmdLineArgs.get("-skipfailedinvocationcounts");
        String parallelMode = (String)cmdLineArgs.get("-parallel");
        if (parallelMode != null) {
            result.parallelMode = parallelMode;
        }
        if ((threadCount = (Integer)cmdLineArgs.get("-threadcount")) != null) {
            result.threadCount = threadCount;
        }
        if ((dptc = (Integer)cmdLineArgs.get("-dataproviderthreadcount")) != null) {
            result.dataProviderThreadCount = dptc;
        }
        if ((defaultSuiteName = (String)cmdLineArgs.get("-suitename")) != null) {
            result.suiteName = defaultSuiteName;
        }
        if ((defaultTestName = (String)cmdLineArgs.get("-testname")) != null) {
            result.testName = defaultTestName;
        }
        if (null != (strClass = (String)cmdLineArgs.get("-listener"))) {
            result.listener = strClass;
        }
        if (null != (ms = (String)cmdLineArgs.get("-methodselectors"))) {
            result.methodSelectors = ms;
        }
        if (null != (objectFactory = (String)cmdLineArgs.get("-objectfactory"))) {
            result.objectFactory = objectFactory;
        }
        if (null != (runnerFactory = (String)cmdLineArgs.get("-testRunFactory"))) {
            result.testRunnerFactory = runnerFactory;
        }
        if ((reporterConfigs = (String)cmdLineArgs.get("-reporterslist")) != null) {
            result.reportersList = reporterConfigs;
        }
        if ((failurePolicy = (String)cmdLineArgs.get("-configfailurepolicy")) != null) {
            result.configFailurePolicy = failurePolicy;
        }
    }

    private void setTestNames(List<String> testNames) {
        this.m_testNames = testNames;
    }

    public void setSkipFailedInvocationCounts(Boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    private void addReporter(ReporterConfig reporterConfig) {
        Object instance = reporterConfig.newReporterInstance();
        if (instance != null) {
            this.addListener(instance);
        } else {
            LOGGER.warn("Could not find reporte class : " + reporterConfig.getClassName());
        }
    }

    public void setMaster(String fileName) {
        this.m_masterfileName = fileName;
    }

    public void setSlave(String fileName) {
        this.m_slavefileName = fileName;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    @Deprecated
    public static void setTestNGVersion() {
        LOGGER.info("setTestNGVersion has been deprecated.");
    }

    public static boolean isJdk14() {
        return false;
    }

    protected static void validateCommandLineParameters(CommandLineArgs args) {
        String testClasses = args.testClass;
        List<String> testNgXml = args.suiteFiles;
        String testJar = args.testJar;
        String slave = args.slave;
        List<String> methods = args.commandLineMethods;
        if (testClasses == null && slave == null && testJar == null && (testNgXml == null || testNgXml.isEmpty()) && (methods == null || methods.isEmpty())) {
            throw new ParameterException("You need to specify at least one testng.xml, one class or one method");
        }
        String groups = args.groups;
        String excludedGroups = args.excludedGroups;
        if (!(testJar != null || null == groups && null == excludedGroups || testClasses != null || testNgXml != null && !testNgXml.isEmpty())) {
            throw new ParameterException("Groups option should be used with testclass option");
        }
        if (args.slave != null && args.master != null) {
            throw new ParameterException("-slave can't be combined with -master");
        }
    }

    public boolean hasFailure() {
        return (this.getStatus() & 1) == 1;
    }

    public boolean hasFailureWithinSuccessPercentage() {
        return (this.getStatus() & 4) == 4;
    }

    public boolean hasSkip() {
        return (this.getStatus() & 2) == 2;
    }

    static void exitWithError(String msg) {
        System.err.println(msg);
        TestNG.usage();
        System.exit(1);
    }

    public String getOutputDirectory() {
        return this.m_outputDir;
    }

    public IAnnotationTransformer getAnnotationTransformer() {
        return this.m_annotationTransformer;
    }

    public void setAnnotationTransformer(IAnnotationTransformer t) {
        this.m_annotationTransformer = t;
    }

    public String getDefaultSuiteName() {
        return this.m_defaultSuiteName;
    }

    public void setDefaultSuiteName(String defaultSuiteName) {
        this.m_defaultSuiteName = defaultSuiteName;
    }

    public String getDefaultTestName() {
        return this.m_defaultTestName;
    }

    public void setDefaultTestName(String defaultTestName) {
        this.m_defaultTestName = defaultTestName;
    }

    public void setConfigFailurePolicy(String failurePolicy) {
        this.m_configFailurePolicy = failurePolicy;
    }

    public String getConfigFailurePolicy() {
        return this.m_configFailurePolicy;
    }

    @Deprecated
    public static TestNG getDefault() {
        return m_instance;
    }

    @Deprecated
    public void setHasFailure(boolean hasFailure) {
        this.m_status |= 1;
    }

    @Deprecated
    public void setHasFailureWithinSuccessPercentage(boolean hasFailureWithinSuccessPercentage) {
        this.m_status |= 4;
    }

    @Deprecated
    public void setHasSkip(boolean hasSkip) {
        this.m_status |= 2;
    }

    public void setMethodInterceptor(IMethodInterceptor methodInterceptor) {
        this.m_methodInterceptor = methodInterceptor;
    }

    public void setDataProviderThreadCount(int count) {
        this.m_dataProviderThreadCount = count;
    }

    public void addClassLoader(ClassLoader loader) {
        if (loader != null) {
            ClassHelper.addClassLoader(loader);
        }
    }

    public static class ExitCodeListener
    implements IResultListener {
        protected TestNG m_mainRunner;

        public ExitCodeListener() {
            this.m_mainRunner = m_instance;
        }

        public ExitCodeListener(TestNG runner) {
            this.m_mainRunner = runner;
        }

        public void onTestFailure(ITestResult result) {
            this.setHasRunTests();
            this.m_mainRunner.setStatus(1);
        }

        public void onTestSkipped(ITestResult result) {
            this.setHasRunTests();
            this.m_mainRunner.setStatus(2);
        }

        public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
            this.setHasRunTests();
            this.m_mainRunner.setStatus(4);
        }

        public void onTestSuccess(ITestResult result) {
            this.setHasRunTests();
        }

        public void onStart(ITestContext context) {
            this.setHasRunTests();
        }

        public void onFinish(ITestContext context) {
        }

        public void onTestStart(ITestResult result) {
            this.setHasRunTests();
        }

        private void setHasRunTests() {
            this.m_mainRunner.m_hasTests = true;
        }

        public void onConfigurationFailure(ITestResult itr) {
            this.m_mainRunner.setStatus(1);
        }

        public void onConfigurationSkip(ITestResult itr) {
            this.m_mainRunner.setStatus(2);
        }

        public void onConfigurationSuccess(ITestResult itr) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SuiteResultCounts {
        int total = 0;
        int skipped = 0;
        int failed = 0;
        int confFailures = 0;
        int confSkips = 0;

        private SuiteResultCounts() {
        }

        public void calculateResultCounts(XmlSuite xmlSuite, Map<XmlSuite, ISuite> xmlToISuiteMap) {
            Collection<ISuiteResult> tempSuiteResult = xmlToISuiteMap.get(xmlSuite).getResults().values();
            for (ISuiteResult isr : tempSuiteResult) {
                ITestContext ctx = isr.getTestContext();
                int _skipped = ctx.getSkippedTests().size();
                int _failed = ctx.getFailedTests().size() + ctx.getFailedButWithinSuccessPercentageTests().size();
                this.skipped += _skipped;
                this.failed += _failed;
                this.confFailures += ctx.getFailedConfigurations().size();
                this.confSkips += ctx.getSkippedConfigurations().size();
                this.total += ctx.getPassedTests().size() + _failed + _skipped;
            }
            for (XmlSuite childSuite : xmlSuite.getChildSuites()) {
                this.calculateResultCounts(childSuite, xmlToISuiteMap);
            }
        }
    }
}

