/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import com.google.inject.internal.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlInclude {
    private String m_name;
    private List<Integer> m_invocationNumbers = Lists.newArrayList();
    private int m_index;

    public XmlInclude(String n) {
        this(n, Collections.emptyList(), 0);
    }

    public XmlInclude(String n, int index) {
        this(n, Collections.emptyList(), index);
    }

    public XmlInclude(String n, List<Integer> list, int index) {
        this.m_name = n;
        this.m_invocationNumbers = list;
        this.m_index = index;
    }

    public String getName() {
        return this.m_name;
    }

    public List<Integer> getInvocationNumbers() {
        return this.m_invocationNumbers;
    }

    public int getIndex() {
        return this.m_index;
    }

    public String toXml(String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        Properties p = new Properties();
        p.setProperty("name", this.getName());
        if (this.getInvocationNumbers().size() > 0) {
            p.setProperty("invocation-numbers", XmlClass.listToString(this.getInvocationNumbers()).toString());
        }
        xsb.addEmptyElement("include", p);
        return xsb.toXML();
    }
}

